<?php
/**
* Smarty
*
* PHP version 5
*
* @package    renderers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'Smarty/Smarty.class.php' );

class SmartyRenderer implements IRenderer
{
	var $_template_files;
	var $_smarty;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_template_files = array();
		$this->_smarty = new Smarty();
	}

	/*
	 * 顼̾
	 */
	public function getRendererName()
	{
		return "Smarty Renderer";
	}

	/*
	 * 顼
	 */
	public function init( Config $config )
	{
		$this->_smarty->caching 		= $config->getBoolean( 'caching' );
		$this->_smarty->compile_check 	= $config->getBoolean( 'compile_check' );
		$this->_smarty->template_dir 	= $config->getString( 'template_dir', TRUE );
		$this->_smarty->compile_dir 	= $config->getString( 'compile_dir', TRUE );
		$this->_smarty->config_dir 		= $config->getString( 'config_dir', TRUE );
		$this->_smarty->cache_dir 		= $config->getString( 'cache_dir', TRUE );

		// ƥץ졼ȥեޥåԥ
		$this->_template_files	= $config->getArray( 'template_files' );
	}

	/*
	 * ƥץ졼ȥե̾
	 */
	private function getTemplateFile( $template_name )
	{
		$template_file = $this->_template_files[ $template_name ];
		if ( !$template_file ){
//$this->_config->dump();
			throw new TemplateFileNotFoundException( $template_name );
		}
		return $template_file;
	}

	/*
	 * 󥰤Ԥ
	 */
	public function render( ProcedureContext $context, Response $response )
	{
		log_info( "system",  "SmartyRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );

		try{

			// Smarty֥Ȥ
			$smarty = $this->_smarty;

			// 쥹ݥ󥹥ǡ򤹤٤Smartyassign
			$keys = $response->getKeys();
			foreach( $keys as $key ){
				$value = $response->get( $key );
				$smarty->assign( $key, $value );
			}

			// ƥץ졼̾
			$template_name = $context->get( 'smarty_template' );

			// ƥץ졼ȥե̾Ѵ
			$template_file = $this->getTemplateFile( $template_name );

			// ƥץ졼ȤŸɽ
			$smarty->display( $template_file );
		}
		catch ( Exception $e ){
			throw new RendererException( "rendering failed", $e );
		}

		log_info( "system",  "SmartyRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );
	}
}
?>