<?php
/**
* åե륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class CacheFile
{
	private $_name;
	private $_header;
	private $_data;
	private $_cacheable;
	private $_timeout;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct( $name, $data = NULL )
	{
		$this->_name = $name;
		$this->_data = $data;
//print "name:$name<BR>";
	}

	/*
	 *    
	 */
	public function initCacheFile( $cache_file_config )
	{
		$this->_cacheable = $cache_file_config->getBoolean( "cacheacble" );
		$this->_timeout   = $cache_file_config->getString( "timeout" );
	}

	/*
	 *    ॢȤ
	 */
	public function getTimeout()
	{
		return $this->_timeout;
	}

	/*
	 *    ǡ
	 */
	public function getData()
	{
		return $this->_data;
	}

	/*
	 *    ǡ
	 */
	public function setData( $data )
	{
		$this->_data = $data;
	}

	/*
	 *    إåå
	 */
	public function checkHeader()
	{
		return $this->_header->checkVersion();
	}

	/*
	 *    ڤå
	 */
	public function checkExpired()
	{
		$now_time = System::now();
		$elapse = $now_time - $this->_header->getCreateTime();
		$timeout = $this->_timeout;
//print "elapse:$elapse<BR>";
//print "_timeout:$timeout<BR>";
		return ($elapse > $timeout);
	}

	/*
	 *    ե뤫
	 */
	public function load()
	{
		// åեѥ
		$cache_file_path = ResourceLocator::getWebAppPath( 'cache', $this->_name );

		// ե뤬뤫
		if ( !is_file($cache_file_path) ){
			return false;
		}

		// եƤ
		$buffer = file( $cache_file_path );

		// إå
		$this->_header = unserialize( array_shift( $buffer ) );

		// ǡ
		$data = array();
		foreach( $buffer as $line ){
			$data[] = unserialize( $line );
		}

		// ¸
		$this->_data = count($data) == 1 ? $data[0] : $data;

		return true;
	}

	/*
	 *    ե¸
	 */
	public function save()
	{
		// åեѥ
		$cache_file_path = ResourceLocator::getWebAppPath( 'cache', $this->_name );

//print "save:$cache_file_path<BR>";

		// إå
		$header = new CacheFileHeader();
		$header->setCreateTime( System::now() );
		$header->setVersion( CacheFileHeader::HEADER_VERSION );

		// ե륪ץ
		$fp = fopen($cache_file_path, 'w');

		// إå񤭹
		fputs( $fp, serialize($header) . "\n" );

		// ꥢ饤
		if ( is_array($this->_data) ){
			foreach( $this->_data as $item ){
				fputs($fp, serialize($item)."\n");
			}
		}
		else{
			fputs($fp, serialize($this->_data)."\n");
		}

		fclose($fp);

	}

}
?>