<?php
/**
* ץΥѥ᡼ݻ륳ƥȥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_ProcedureContext 
{
	public $session;
	public $db;

	private $_proc_name;
	private $_data;
	private $_res_cache;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct( $proc_name, charcoal_IProcedure $procedure, charcoal_Session $session )
	{
		$this->session        = $session;
		$this->db             = new charcoal_DB();

		$this->_proc_name     = $proc_name;
		$this->_data          = array();
		$this->_res_cache     = new charcoal_ResourceCache();
	}

	/*
	 *    ץ̾
	 */
	public function getProcedureName()
	{
		return $this->_proc_name;
	}

	/*
	 * ݡͥȤ
	 */
	public function getComponent( $component_name )
	{
		return charcoal_DIContainer::getComponent( $component_name );
	}

	/*
	 * ե
	 */
	public function getForm( $form_name )
	{
		return charcoal_FormFactory::create( $form_name );
	}

	/*
	 *    ǡ١֥Ȥ
	 */
	public function getDB()
	{
		return $this->db;
	}

	/*
	 *    å󥪥֥Ȥ
	 */
	public function getSession()
	{
		return $this->session;
	}

	/*
	 *    ꥽
	 */
	public function getResource( $name )
	{
		return $this->_res_cache->get( $name, $this );
	}

	/*
	 *    
	 */
	public function getKeys()
	{
		return array_keys( $this->_data );
	}

	/*
	 * ƥͤ
	 */
	public function get( $key )
	{
		return isset($this->_data[ $key ]) ? $this->_data[ $key ] : NULL;
	}

	/*
	 * ƥͤ
	 */
	public function set( $key, $value )
	{
		$this->_data[ $key ] = $value;
	}

	/*
	 * 
	 */
	public function dump()
	{
		System::dumpArray( $this->_data );
	}

	/*
	 * ʸ
	 */
	public function __toString()
	{
		$str = "[ProcedureContext]<BR>" . charcoal_System::arrayToString( $this->_data );
		return $str;
	}
}

