<?php
/**
* 饹˴ؤ桼ƥƥ
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_ClassUtil
{
	/*
	 * 饹̾򸡾
	 */
	public static function validateClassName( $class_name )
	{
		return preg_match( "/\A[a-zA-Z]\w*/", "$class_name" );
	}

	/*
	 * 饹
	 */
	public static function loadClass( $class_path, $class_name )
	{
		// ѥ̤
		if ( !$class_path ){
			return FALSE;
		}

		// ʤ㳰򥹥
		$include_path_list = explode( PATH_SEPARATOR, get_include_path() );
		$found = FALSE;
		foreach( $include_path_list as $include_path ){
			$path = $include_path . DIRECTORY_SEPARATOR . $class_path;
			if ( is_file($path) ){
				$found = TRUE;
				break;
			}
		}
		if ( !$found ){
			$msg = "Source file path[$class_path] is not file";
			require_once( 'exceptions/ClassNotFoundException.class.php' );
			throw new charcoal_ClassNotFoundException($class_name,$class_path,$msg);
		}

		// ɤ߹
		require_once( $class_path );

		// 饹̤ʤ㳰򥹥
		if ( !class_exists($class_name,FALSE) && !interface_exists($class_name,FALSE) ){
			$msg = "Class[$class_name] is not defined in source file[$class_path]";
			require_once( 'exceptions/ClassNotFoundException.class.php' );
			throw new charcoal_ClassNotFoundException($class_name,$class_path,$msg);
		}

		return TRUE;
	}

	/*
	 * 饹Υ󥹥󥹤
	 */
	public static function newInstance( charcoal_String $class_name, $args = NULL )
	{
//		$usage = new charcoal_MemoryUsage();

		$class_name = $class_name->getValue();

		if ( !class_exists($class_name) ){
			throw new charcoal_ClassNotFoundException( $class_name );
		}

		$reflection = new ReflectionClass( $class_name );
		$instance = $reflection->newInstance( $args );

//		$usage->printDelta("$class_name");

		return $instance;
	}

	/*
	 * 饹󥿥եƤ뤫ǧ
	 */
	public static function testImplements( $object, $interface_name )
	{
		return ( $object instanceof $interface_name );
	}

}
