<?php
/**
* HTTPꥯȤåפ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_Request 
{
	var $_get;
	var $_post;
	var $_mixed;
	var $_url;

	const TYPE_GET      = "get";
	const TYPE_POST     = "post";
	const TYPE_MIXED    = "mixed";

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_get   = $_GET;
		$this->_post  = $_POST;
		$this->_mixed = $_GET + $_POST;

		$url_string = "http://" . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];

		$this->_url = new charcoal_URL($url_string);

//		unset( $_POST );
//		unset( $_GET );
	}

	/*
	 *    URL
	 */
	public function getURL()
	{
		return $this->_url;
	}

	/*
	 *    
	 */
	public function getKeys( $type = self::TYPE_MIXED )
	{
		switch ( $type ){
		case self::TYPE_GET:
			return array_keys( $this->_get );
			break;
		case self::TYPE_POST:
			return array_keys( $this->_post );
			break;
		case self::TYPE_MIXED:
			return array_keys( $this->_mixed );
			break;
		}
		return NULL;
	}

	/*
	 *    ѥ᡼
	 */
	public function get( $key, $type = self::TYPE_MIXED )
	{
		switch ( $type ){
		case self::TYPE_GET:
			return isset( $this->_get[$key] ) ? $this->_get[$key] : NULL;
			break;
		case self::TYPE_POST:
			return isset( $this->_post[$key] ) ? $this->_post[$key] : NULL;
			break;
		case self::TYPE_MIXED:
			return isset( $this->_mixed[$key] ) ? $this->_mixed[$key] : NULL;
			break;
		}
		return NULL;
	}

	/*
	 *    ѥ᡼
	 */
	public function set( $key, $value, $type = self::TYPE_MIXED )
	{
		switch ( $type ){
		case self::TYPE_GET:
			$this->_get[ $key ] = $value;
			break;
		case self::TYPE_POST:
			$this->_post[ $key ] = $value;
			break;
		case self::TYPE_MIXED:
			$this->_mixed[ $key ] = $value;
			$this->_get[ $key ] = $value;
			$this->_post[ $key ] = $value;
			break;
		}
	}

	/*
	 *    ѥ᡼
	 */
	public function setArray( $array, $type = self::TYPE_MIXED )
	{
		switch ( $type ){
		case self::TYPE_GET:
			$this->_get = $this->_get + $array;
			break;
		case self::TYPE_POST:
			$this->_post = $this->_post + $array;
			break;
		case self::TYPE_MIXED:
			$this->_mixed = $this->_mixed + $array;
			$this->_get = $this->_get + $array;
			$this->_post = $this->_post + $array;
			break;
		}
	}

	/*
	 * 
	 */
	public function dump()
	{
		print "----------[ Request(GET) ]---------------<BR>";
		charcoal_System::dumpArray( $this->_get );

		print "----------[ Request(POST) ]---------------<BR>";
		charcoal_System::dumpArray( $this->_post );

		print "----------[ Request(MIXED) ]---------------<BR>";
		charcoal_System::dumpArray( $this->_mixed );
	}

	/*
	 * ʸ
	 */
	public function __toString()
	{
		$str = "[Request]<BR>" . charcoal_System::arrayToString( $this->_mixed );
		return $str;
	}
}
