<?php
/**
* ǥեȤΥեǥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
abstract class charcoal_DefaultFormModel implements charcoal_IFormModel
{
	private $_class_name;
	private $_class_vars;
	private $_annotations;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_class_name = get_class($this);
		$this->_class_vars = get_class_vars($this->_class_name);

		$this->_annotation_list = array();
		foreach( $this->_class_vars as $key => $var ){
			if ( strpos($var,'@') !== FALSE ){
				$this->_annotations[$key] = charcoal_AnnotationUtil::parse( $key, $var );
			}
		}
	}

	/*
	 *	ե̾
	 */
	public function getFormName()
	{
		if ( property_exists($this,'___form_name') ){
			$table_name = $this->___form_name;
		}
		else{
			$table_name = $this->_class_name;
		}
		return $table_name;
	}

	/**
	 * եɤ¸ߤ뤫
	 */
	public function fieldExists( $field_name )
	{
		return isset($this->_class_vars[$field_name]);
	}

	/*
	 *   ե̾
	 */
	public function getFieldList()
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_list ){
				foreach( $annot_list as $annot ){
					// @fieldꤵƤե
					if ( $annot && $annot->getName() === 'field' && $annot->getValue() === NULL ){
						$result[] = $field;
					}
				}
			}
		}

		return $result;
	}

	/*
	 *   ϥȥ
	 */
	public function getInputList()
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_list ){
				foreach( $annot_list as $annot ){
					// @inputꤵƤե
					if ( $annot && $annot->getName() === 'input' && $annot->getValue() === NULL ){
						$result[] = $field;
					}
				}
			}
		}

		return $result;
	}

	/*
	 *   Υơ
	 */
	public function getAnnotation( $field, $annotation_name )
	{
		if ( !isset($this->_annotations[$field]) ){
			return NULL;
		}
		$annotation_list = $this->_annotations[$field];
		if ( !isset($annotation_list[$annotation_name]) ){
			return NULL;
		}
		$annot = $annotation_list[$annotation_name];
		return $annot;
	}

	/*
	 *   Υơͤ
	 */
	public function getAnnotationValue( $field, $annotation_name )
	{
		$annot = $this->getAnnotation( $field, $annotation_name );

		return $annot ? $annot->getValue() : NULL;
	}


	/*
	 *   եॢΥơ
	 */
	public function getFormAnnotation( $type )
	{
		$field = '___form';
		return $this->getAnnotation( $field, $type );
	}

	/*
	 *   եॢΥơͤ
	 */
	public function getFormAnnotationValue( $type )
	{
		$field = '___form';
		return $this->getAnnotationValue( $field, $type );
	}

	/*
	 *   ǥեȤΥץ󥯥饹
	 */
	public function getDefaultCaptionClass()
	{
		$key = "___default_caption_class";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}

	/*
	 *   ǥեȤΥץ󥹥
	 */
	public function getDefaultCaptionStyle()
	{
		$key = "___default_caption_style";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}

	/*
	 *   ǥեȤΥեɥ饹
	 */
	public function getDefaultFieldClass( $field_type )
	{
		$key = "___default_{$field_type}_class";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}

	/*
	 *   ǥեȤΥեɥ
	 */
	public function getDefaultFieldStyle( $field_type )
	{
		$key = "___default_{$field_type}_style";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}


	/*
	 *   ꥹȤθ
	 */
	public function getChoiceList( $list_name )
	{
	}


	/*
	 *   
	 */
	public function dump()
	{
		print "[annotation dump]<BR>";
		print "form name:" . $this->getFormName() . "<BR>";
		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_array ){
				print "field[$field]:<BR>";
				foreach( $annot_array as $name => $annot ){
					print str_repeat('&nbsp;',8);
					print '@' . $name . ' value=&gt;' . $annot->getValue() . ' param=&gt;' . $annot->getParameter() . '<BR>' ;
				}
			}
		}
	}

}
