<?php
/**
* HTMLե४֥ȤΥեȥꥯ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_HTMLFormFactory
{
	private $_form_model;

	/*
	 *	DTO˥åȤ줿ͤŸ
	 */
	private static function _setDTO( $field, charcoal_DTO $dto )
	{
	}

	/*
	 *	ե
	 */
	public static function create( charcoal_IFormModel $model, charcoal_DTO $dto, $read_only = FALSE )
	{
		// ID
		$id = 0;

		// ե४֥Ȥ
		$action  = $model->getFormAnnotationValue( 'action' );
		$method  = $model->getFormAnnotationValue( 'method' );
		$target  = $model->getFormAnnotationValue( 'target' );
		$class   = $model->getFormAnnotationValue( 'class' );
		$style   = $model->getFormAnnotationValue( 'style' );

		$attributes = array();
		$attributes['id'] = ++$id;
		$attributes['action'] = $action;
		$attributes['method'] = $method;
		$attributes['target'] = $target;
		$attributes['class'] = $class;
		$attributes['style'] = $style;

		$form = new charcoal_HTMLFormObject( $attributes );

		// ѥͥɲ
		$form_panels = array();
		$panel_list = $model->getPanelList();
		if ( $panel_list ){
			foreach( $panel_list as $field ){
				$layout  = $model->getAnnotationValue( $field, 'layout' );
				$class   = $model->getAnnotationValue( $field, 'class' );
				$style   = $model->getAnnotationValue( $field, 'style' );

				$attributes = array();
				$attributes['id'] = ++$id;
				$attributes['class'] = $class;
				$attributes['style'] = $style;

				$panel = new charcoal_HTMLPanelObject( s($layout), $attributes );
				$form_panels[$field] = $panel;
				$form->addChild( $panel );
			}
		}

		// ϥȥɲ
		$input_list = $model->getInputList();
		if ( $input_list ){

			$panels = array();

			foreach( $input_list as $field ){
				// ϥ
				$type = $model->getAnnotationValue( $field, 'input_type' );
				if ( !$type ){
					// ϥפɬ
					continue;
				}

				// ѥͥ
				$panel = $model->getAnnotationValue( $field, 'panel' );
				if ( !$panel || !isset($form_panels[$panel]) ){
					// ѥͥɬ
					continue;
				}
				$panel = $form_panels[$panel];

				// ץ
				$caption = $model->getAnnotationValue( $field, 'caption' );
				if ( $caption ){
					$default_caption_class = $model->getDefaultCaptionClass();
					$default_caption_style = $model->getDefaultCaptionStyle();
					$class = $model->getAnnotationValue( $field, 'caption_class' );
					$style = $model->getAnnotationValue( $field, 'caption_style' );
					$attributes = array();
					$attributes['id'] = ++$id;
					$attributes['class'] = $class ? $class : $default_caption_class;
					$attributes['style'] = $style ? $style : $default_caption_style;
					$text = new charcoal_HTMLTextObject( s($caption), $attributes );
					$panel->addChild( $text );
				}

				// ϥե
				$default_field_class = $model->getDefaultFieldClass($type);
				$default_field_style = $model->getDefaultFieldStyle($type);
				$class = $model->getAnnotationValue( $field, 'class' );
				$style = $model->getAnnotationValue( $field, 'style' );
				$value = $model->getAnnotationValue( $field, 'value' );
				$attributes = array();
				$attributes['id'] = ++$id;
				$attributes['type'] = $type;
				$attributes['name'] = $field;
				$attributes['class'] = $class ? $class : $default_field_class;
				$attributes['style'] = $style ? $style : $default_field_style;

				if ( $value === '%DTO_VALUE%' ){
					$value = $dto->$field;
				}

				$input = NULL;

				switch ( $type ){
				case 'text':
				case 'password':
					if ( $read_only ){
						$attributes['class'] = NULL;
						$attributes['style'] = NULL;
						$input = new charcoal_HTMLTextObject( s($value), $attributes );
					}
					else{
						$size = $model->getAnnotationValue( $field, 'size' );
						$attributes['value'] = $value;
						$attributes['size'] = $size;
						$input = new charcoal_HTMLInputObject( $attributes );
					}
					$panel->addChild( $input );
					break;
				case 'submit':
				case 'reset':
					if ( !$read_only ){
						$attributes['value'] = $value;
						$input = new charcoal_HTMLInputObject( $attributes );
						$panel->addChild( $input );
					}
					break;
				case 'textarea':
					if ( $read_only ){
						$attributes['class'] = NULL;
						$attributes['style'] = NULL;
						$text = nl2br($value);
						$input = new charcoal_HTMLTextObject( s($text), $attributes );
					}
					else{
						$cols = $model->getAnnotationValue( $field, 'cols' );
						$rows = $model->getAnnotationValue( $field, 'rows' );
						$attributes['cols'] = $cols;
						$attributes['rows'] = $rows;
						$input = new charcoal_HTMLTextAreaObject( s($text), $attributes );
					}
					$panel->addChild( $input );
					break;
				case 'radio':
				case 'checkbox':
					$choice_list_name = $model->getAnnotationValue( $field, 'choice_list' );
					$choice_list = $model->getChoiceList( $choice_list_name );
					if ( $read_only ){
						if ( is_array($value) ){
							$caption =NULL;
							foreach( $value as $choice ){
								if ( isset($choice_list[$choice]) ){
									if ( $caption ){
										$caption .= ',&nbsp;';
									}
									$caption .= $choice_list[$choice];
								}
							}
							$input = new charcoal_HTMLTextObject( s($caption), $attributes );
						}
					}
					else{
						$attributes['value'] = $value;
						$attributes['name'] = $field . '[]';
						$checked = $model->getAnnotationValue( $field, 'checked' );
						$check_status = $checked ? explode( ',', $checked ) : NULL;
						$class = $model->getAnnotationValue( $field, 'choice_caption_class' );
						$style = $model->getAnnotationValue( $field, 'choice_caption_style' );
						$caption_attributes = array();
						$caption_attributes['id'] = ++$id;
						$caption_attributes['class'] = $class ? $class : NULL;
						$caption_attributes['style'] = $style ? $style : NULL;
						$input = new charcoal_HTMLChoiceGroupObject( $attributes, $caption_attributes, $choice_list, $check_status );
					}
					$panel->addChild( $input );
					break;
				case 'select':
					$choice_list_name = $model->getAnnotationValue( $field, 'choice_list' );
					$choice_list = $model->getChoiceList( $choice_list_name );
					if ( $read_only ){
						$caption = isset($choice_list[$value]) ? $choice_list[$value] : NULL;
						$attributes['class'] = NULL;
						$attributes['style'] = NULL;
						$input = new charcoal_HTMLTextObject( s($caption), $attributes );
					}
					else{
						$input = new charcoal_HTMLSelectObject( $attributes, $choice_list, $value );
					}
					$panel->addChild( $input );
					break;
				}

			}
		}

		return $form;
	}

}
