<?php

/**
* DB饹
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class charcoal_DB
{
	private $_source;
	private $_builder;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		if ( charcoal_Profile::getBoolean('USE_DB') ){
			$data_source_name = charcoal_Profile::getString( 'DB_DATA_SOURCE' );
			$this->_source = charcoal_DataSourceFactory::create( $data_source_name );

			$builder_name = $this->_source->getBackend();
			if ( $builder_name ){
				$this->_builder = charcoal_SQLBuilderFactory::create( $builder_name );
			}
		}
	}

	/*
	 *	ǡ
	 */
	public function getDataSource()
	{
		return $this->_source;
	}

	/*
	 *	SQLӥ
	 */
	public function getSQLBuilder()
	{
		return $this->_builder;
	}

	/*
	 *	¸
	 */
	public  function save( charcoal_ITableModel $model, charcoal_DTO $dto, $converter_str = NULL )
	{
		$conv = $converter_str ? charcoal_EncodingConverter::fromString($converter_str) : NULL;

		try{
			// եɤꤵƤUPDATEꤵƤʤINSERTȽ
			$pk = $model->getPrimaryKeyField();
			$is_new = !isset($dto[$pk]) || is_null($dto[$pk]) ? TRUE : FALSE;

			// SQL
			if ( $is_new ){
				list( $sql, $params ) = $this->_builder->buildInsertSQL( $model, $dto );
			}
			else{
				list( $sql, $params ) = $this->_builder->buildUpdateSQL( $model, $dto );
			}

			// ʸѴ
			if ( $conv ){
				foreach( $params as $key => $value ){
					if ( is_string($value) ){
						$value = $conv->convertEncoding( $value );
						$params[$key] = $value;
					}
				}
			}

			// SQL¹
			$this->_source->prepareExecute( $sql, $params );

			// ID֤
			if ( $is_new ){
				$sql = $this->_builder->buildLastIdSQL();
				
				// ¹
				$result = $this->_source->prepareExecute( $sql );

				// եå
				$row = $this->_source->fetchArray( $result );

				$new_id = $row[0];
			}
			else{
				$new_id = $dto[$pk];
			}

			return $new_id;
		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#save failed", $e );
		}
	}

	/*
	 *	SQL¹(INSERT/DELETE/UPDATE)
	 */
	public  function execute( $sql, $params = NULL )
	{
		try{
			// ¹
			$this->_source->prepareExecute( $sql, $params );
		}
		catch ( Exception $e ) {

			// ̤throw
			throw new charcoal_DBException( "exec_SQL failed", $e );
		}
	}

	/*
	 *	SQL¹(SELECT)
	 */
	public  function query( $sql, $params = NULL )
	{
		// ƥʤDataSourceݡͥȤ
		$ds = $this->_source;

		$a = array();

		try{

			// ¹
			$result = $ds->prepareExecute( $sql, $params );

			// եå
			while( $row = $ds->fetchAssoc( $result ) ){
				$a[] = $row;
			}
		}
		catch ( Exception $e ) {

			// ̤throw
			throw new charcoal_DBException( "exec_SQL failed", $e );
		}

		return $a;
	}

	/*
	 *	SQL
	 */
	public  function findBySQL( charcoal_ITableModel $model, $sql, $params = NULL, $converter_str = NULL ) 
	{
		$conv = $converter_str ? charcoal_EncodingConverter::fromString($converter_str) : NULL;

		$a = array();

		// DataSource
		$ds = $this->_source;

		try{
			// եɰ
			$field_list = $model->getFieldList();

			// ¹
			$result = $ds->prepareExecute( $sql, $params );

			// եå
			while( $row = $ds->fetchAssoc( $result ) )
			{
				$result_row = array();
				foreach ($field_list as $name) 
				{
					// ե
					$value = $row[ $name ];
					// ʸʤ饨󥳡ǥѴ
					if ( $conv && is_string($value) ){
						$value = $conv->convertEncoding($value);
					}
					// ֵ
					$result_row[$name] = $value;
				}
				$a[] = $result_row;
			}
		}
		catch ( Exception $e ) {

			// ̤throw
			throw new charcoal_DBException( "findBySQL failed", $e );
		}

		return $a;
	}

	/*
	 *	ǽΣ
	 */
	public  function findFirst( $dto, charcoal_SQLCriteria $condition = NULL, $converter_str = NULL ) 
	{
		if ( !$condition ){
			$condition = new charcoal_SQLCriteria();
		}

		// LIMIT=1
		$condition->setLimit( 1 );

		// ¹
		$result = $this->findAll( $dto, $condition, $converter_str );

		return array_shift($result);
	}

	/*
	 *	
	 */
	public  function findAll( charcoal_ITableModel $model, charcoal_SQLCriteria $criteria = NULL, $converter_str = NULL ) 
	{
		try{
			// ơ֥̾
			$table = $model->getTableName();

			// SQLӥ
			$builder = $this->_builder;

			// SQLκ
			$sql = $builder->buildSelectSQL( $model, $criteria );

			// ѥ᡼
			$params = $criteria ? $criteria->getParams() : NULL;

			// ¹
			$result = $this->findBySQL( $model, $sql, $params, $converter_str );

			return $result;
		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#findAll failed", $e );
		}
	}

	/*
	 *	ĤΥեɤΤߤǸ
	 */
	public  function findAllBy( charcoal_ITableModel $model, $field, $value, charcoal_SQLCriteria $criteria = NULL, $converter_str = NULL )
	{
		if ( !$criteria ){
			$criteria = new charcoal_SQLCriteria();
		}

		$criteria->setWhereClause( "$field = ?" );
		$criteria->setParams( array( $value ) );

		$a = $this->findAll( $model, $criteria, $converter_str );

		return $a;
	}

	/*
	 *	ID鸡(Ĥꤷ)
	 */
	public  function findByID( charcoal_ITableModel $model, $id, $converter_str = NULL ) 
	{
		// Ĥꤷ
		$where_clause = 'id = ?';
		$params = array( $id );

		$criteria = new charcoal_SQLCriteria( $where_clause, $params );

		$a = $this->findAll( $model, $criteria, $converter_str );

		return array_shift($a);
	}

	/*
	 *	ID鸡
	 */
	public  function findAllByID( charcoal_ITableModel $model, $id_array ) 
	{
		// ʣĻꤷ
		$where = array();
		$params = array();
		
		foreach( $id_array as $id ){
			$where[] = "?";
			$params[] = $id;
		}

		$where_clause = "id in (" . implode(",",$where) . ")";

		$condition = new charcoal_SQLCriteria( $where_clause, $params );

		$a = $this->findAll( $dto, $condition );

		return $a;
	}

	/*
	 *	ʣĤꤷ
	 */
	public  function destroyById( charcoal_ITableModel $model, $id ) 
	{
		try{
			// ե̾
			$pk = $model->getPrimaryKeyField();

			// SQLѥ᡼
			$params = array( "$id" );

			// 
			$criteria = new charcoal_SQLCriteria();
			$criteria->setWhereClause( "$pk = ?" );
			$criteria->setParams( $params );

			// SQLӥȤSQL
			$sql = $this->_builder->buildDeleteSQL( $model, $criteria );

			$this->execute( $sql, $params );
		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#destroyById failed", $e );
		}
	}

	/*
	 *	ʣꤷ
	 */
	public  function destroyAllById( charcoal_ITableModel $model, $id_array ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto );

			// ʣĻꤷ
			$where = array();
			$params = array();
			
			foreach( $id_array as $id ){
				$where[] = "?";
				$params[] = $id;
			}

			$sql = "delete from $table where id in (" . implode(",",$where) . ")";

			$this->execute( s($sql), a($params) );
		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#destroyById failed", $e );
		}
	}

	/*
	 *	ĤΥեɤ˹פ쥳ɤ
	 */
	public  function destroyBy( charcoal_ITableModel $model, $field, $value )
	{
		$where_clause = "$field = ?";
		$params = array( $value );

		$this->destroyAll( $dto, $where_clause, $params );
	}


	/*
	 *	˹פ쥳ɤ
	 */
	public  function destroyAll( charcoal_ITableModel $model, $where_clause = NULL, $params = NULL ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto );

			$sql = "delete from $table where $where_clause";

			$this->execute( $sql, $params );
		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#destroyAll failed", $e );
		}
	}

	/*
	 *	ơ֥Υ쥳ɿ
	 */
	public  function count( charcoal_ITableModel $model, $where_clause = NULL, $params = NULL ) 
	{
		try{
			if ( $where_clause ){
				$criteria = new charcoal_SQLCriteria();
				$criteria->setWhereClause( $where_clause );
				$criteria->setParams( $params );
			}
			else{
				$criteria = NULL;
			}

			// SQL
			$sql = $this->_builder->buildCountSQL( $model, $criteria );

			// SQL¹
			$result = $this->_source->prepareExecute( $sql, $params );

			// եå
			$rows = $this->_source->fetchArray( $result );

			return $rows[0];
		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#count failed", $e );
		}
	}

	/*
	 *	եɤκͤ
	 */
	public  function max( charcoal_ITableModel $model, $field_name, $where_clause = NULL, $params = NULL ) 
	{
		try{
			if ( $where_clause ){
				$criteria = new charcoal_SQLCriteria();
				$criteria->setWhereClause( $where_clause );
				$criteria->setParams( $params );
			}
			else{
				$criteria = NULL;
			}

			// SQL
			$sql = $this->_builder->buildMaxSQL( $model, $field_name, $criteria );

			// SQL¹
			$result = $this->_source->prepareExecute( $sql, $params );

			// եå
			$rows = $this->_source->fetchArray( $result );

			return $rows[0];
		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#count failed", $e );
		}
	}


	/*
	 *	DB
	 */
	public  function createDatabase( $db_name, $charset ) 
	{
		try{
			// SQLӥȤSQL
			$sql = $this->_builder->buildCreateDatabaseSQL( $db_name, $charset );

			// SQL¹
			$this->_source->execute( $sql );

		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#createDB failed", $e );
		}
	}

	/*
	 *	ơ֥
	 */
	public  function createTable( charcoal_ITableModel $model ) 
	{
		try{
			// SQLӥȤSQL
			$sql = $this->_builder->buildCreateTableSQL( $model );

			// SQL¹
			$this->_source->execute( $sql );

		}
		catch ( Exception $e ){
			throw new charcoal_DBException( "DB#createDB failed", $e );
		}
	}
}
