<?php
/**
* HTML֥ȥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

abstract class charcoal_HTMLObject
{
	protected $_tag;
	protected $_attributes;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( charcoal_String $tag, $attributes )
	{
		$this->_tag          = $tag;
		$this->_attributes   = $attributes;
	}

	/*
	 *	HTML
	 */
	abstract public function toHTML();

	/*
	 *	°
	 */
	public function getAttribute( $attr_name )
	{
		if ( !$this->_attributes || !isset($this->_attributes[$attr_name]) ){
			return NULL;
		}
		return $this->_attributes[ $atr_name ];
	}

	/*
	 *	ϥ
	 */
	public function startTag()
	{
		$conv = charcoal_EncodingConverter::fromString( 'PHP_TO_HTML' );

		$tag = $this->_tag;
		$html = '<'. $tag;

		// °
		$attributes = $this->_attributes;
		if ( $attributes ){
			foreach( $attributes as $name => $value ){
				if ( $name && $value ){
					$value = $conv->convertEncoding( $value );
					$html .= ' ' . $name . '="' . $value . '"';
				}
			}
		}
		$html .= '>';

		return $html;
	}

	/*
	 *	λ
	 */
	public function endTag()
	{
		return '</' . $this->_tag . '>';
	}

	/*
	 *	ʸ
	 */
	final public function __toString()
	{
		return $this->toHTML();
	}
 
}
