<?php
/**
* ץեȥ꡼饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_ProcedureFactory
{
	/*
	 * ץ
	 */
	public static function create( $proc_key )
	{
		log_info( "system",  "ץ[$proc_key]ɤޤ", __FILE__, __LINE__ );

		// proc_list.iniɤ߹
		$config_file = charcoal_ResourceLocator::getPath( charcoal_ResourcePath::CONFIG, "proc_list.ini" );
		if ( is_file($config_file) ){
			$proc_list = parse_ini_file($config_file,FALSE);
		}
		else{
			$proc_list = array();
		}
		
		// ϿƤʤꤵ줿404
		if ( !isset($proc_list[ $proc_key ]) ){
			throw new charcoal_HttpException( 404 );
		}

		// ץ㥭ץ̾Ѵ
		$proc_name = $proc_list[ $proc_key ];

		// ProcedureConfig
		$config = charcoal_ConfigLoader::loadConfig( $proc_name, "procedure" );

		// 饹̾
		$class_name = $config->getString( 'class_name' );

		if ( !$class_name ){
			throw new charcoal_ProcedureConfigException( $proc_name, 'class_name' );
		}

		// ץΥ󥹥
		$procedure = charcoal_ClassUtil::newInstance( $class_name );

		// 󥹥󥹤Iprocedure󥿥եƤ뤫ǧ
		if ( !($procedure instanceof charcoal_IProcedure) ){
			// 㳰
			throw new charcoal_InterfaceImplementException( $class_name, "charcoal_IProcedure" );
		}

		log_info( "system",  "ץ[$proc_key]ޤ", __FILE__, __LINE__ );

		// ץ
		$procedure->init( $config );

		log_info( "system",  "ץ[$proc_key]ɤޤ", __FILE__, __LINE__ );

		// ץ㡢ץֵ̾
		return array( $procedure, $proc_name );
	}
}
