<?php
/**
* Ūʴؿ򽸤᤿饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_System
{
	/**
	 *	̾
	 */
	public static function getTypeName( $v ){
		return gettype( $v );
	}

	/*
	 *    ߻֤
	 */
	public static function now(){ 
		list($msec,$sec) = explode(' ',microtime()); 
		return ( (float)$msec + (float)$sec );
	}

	/**
	 *	Ĥդκʬñ̤ǵ
	 */
	public static function dateDiff( $date1, $date2 = NULL ){
		if ( $date2 == NULL ){
			// 
			$date2 = date("Y/m/d");
		}
		$result = strtotime($date2) - strtotime($date1);
		$result = intval( $result / (24 * 60 * 60));
		return $result;
	}

	/**
	 *	Ĥդ
	 */
	public static function compareDate( $date1, $date2 = NULL ){
		if ( $date2 == NULL ){
			// 
			$date2 = date("Y/m/d");
		}
		$result = strtotime($date1) - strtotime($date2);
		return $result;
	}

	/*
	 *    ʸˤ
	 *
	 */
	public static function arrayToString( $ary, $line_end = NULL, $indent = NULL, EncodingConverter $conv = NULL )
	{
		if ( $ary === NULL ){
			return '';
		}
		if ( $line_end === NULL ){
			$line_end = '<BR>';
		}
		if ( $indent === NULL ){
			$indent = '--';
		}
		if ( $conv ){
			return self::_arrayToString( $ary, $line_end, $indent, 0, $conv );
		}
		else{
			return self::_arrayToString( $ary, $line_end, $indent, 0 );
		}
	}

	private static function _arrayToString( $ary, $line_end, $indent, $level, EncodingConverter $conv = NULL )
	{
		$buffer = '';
		foreach( $ary as $key => $val ){
			if ( is_array($val) ){
				// ƵƤӽФ
				$buffer .= str_repeat( $indent, $level );
				$buffer .= "[$key]=$val" . $line_end;
	 			$buffer .= self::_arrayToString( $val, $line_end, $indent, $level+1, $conv );
			}
			else if ( is_object($val) ){
				if ( method_exists($val,"__toString") ){
					// __toString()᥽åɤƤ__ToString()᥽åɤɽǤ
					$val = (string)$val;
					if ( $conv ){
						$val = $conv->convertEncoding($val);
					}
					$buffer .= str_repeat( $indent, $level );
					$buffer .= "[$key]=$val" . $line_end;
				}
				else{
					// Ƥʤϥ饹̾ɽ
					$val = '(class)' . get_class($val);
					$buffer .= str_repeat( $indent, $level );
					$buffer .= "[$key]=$val" . $line_end;
				}
			}
			else{
				// ֥ȷ󷿰ʳϤΤޤɲ
				if ( $conv ){
					$val = $conv->convertEncoding($val);
				}
				$buffer .= str_repeat( $indent, $level );
				$buffer .= "[$key]=$val" . $line_end;
			}
		}
		return $buffer;
	}

	/*
	 *    ѿפ
	 */
	public static function dumpVar( $var, $title = NULL, $line_end = "<BR>", $indent = "&nbsp;", $to_encoding = NULL, $from_encoding = NULL )
	{
		if ( is_array($var) ){
			// ξ
			self::dumpArray( $var, $title, $line_end, $indent, $to_encoding, $from_encoding );
			return;
		}
		else if ( is_object($var) ){
			// ֥Ȥξ
			if ( !method_exists($var,"__toString") ){
				// __toStringƤʤϥ顼ȤʤΤǡ饹̾ɽ
				$var = get_class($var);
			}
		}

		// ¾ηξStringѴǽȤߤʤ
		print "$line_end-----------[ $title array dump start ]-----------$line_end";
		print $var;
		print "$line_end-----------[ $title array dump end ]-----------$line_end";
	}

	/*
	 *    
	 *
	 */
	public static function dumpArray( $ary, $title = NULL, $line_end = NULL, $indent = NULL, EncodingConverter $conv = NULL )
	{
		if ( $title == NULL ){
			$title = "$ary";
		}
		if ( $line_end == NULL ){
			$line_end = s('<BR>');
		}
		if ( $indent == NULL ){
			$indent = s('--');
		}
		if ( $conv ){
			$str = self::arrayToString( $ary, $line_end, $indent, $conv );
		}
		else{
			$str = self::arrayToString( $ary, $line_end, $indent );
		}
		print "$line_end------------[ $title START ]------------$line_end";
		print $str;
		print "$line_end------------[ $title END ]------------$line_end";
	}

	/*
	 *    󤫤ǡ򸡺
	 */
	public static function getArrayData( $key, $array )
	{
		if ( isset($array[$key]) ){
			return $array[$key];
		}
		return null;
	}

	/*
	 *    󤫤饭ʬפǡ֤
	 */
	public static function makeSubArray( $part, $ary )
	{
		// 
		$keys = array_keys( $ary );
		// ֵѤ
		$ret = array();
		// Ȥ˳ǧ
		foreach( $keys as $key ){
			// פ뤫
			$pos = strpos($key,$part);
			if ( is_int($pos) && $pos >= 0 ){
				// ͤ
				$val = $ary[ $key ];
				// פʬƿ
				$new_key = substr( $key, $pos + strlen($part) );
				// ¸
				$ret[ $new_key ] = $val;
			}
		}

		return $ret;
	}

	/** 
	 *	ʸΥ󥳡ǥȽ
	 */
	public static function detectEncoding( $str, $detect_order = "EUC-JP, SJIS, JIS, UTF-8" ){

		return mb_detect_encoding( $str, $detect_order, TRUE );

	}

	/**
	 *	󥳡Ѵ
	 */
	public static function encode( $str, $to_encoding = NULL, $from_encoding = NULL )
	{
		if ( is_string($str) && $to_encoding ){
			// 󥳡ɤ
			return mb_convert_encoding($str,$to_encoding, $from_encoding);
		}
		// 󥳡̵
		return $str;
	}

	/**
	 *	󥨥󥳡Ѵ
	 */
	public static function encodeAssoc( $ary, $to_encoding = NULL, $from_encoding = NULL )
	{
		$new_array = array();
		foreach( $ary as $key => $value ){
			$new_array[ $key ] = self::encode( $value, $to_encoding, $from_encoding );
		}
		return $new_array;
	}

	/**
	 *	󥨥󥳡Ѵ
	 */
	public static function encodeArray( $ary, $to_encoding = NULL, $from_encoding = NULL )
	{
		$new_array = array();
		foreach( $ary as $item ){
			$new_array[] = self::encode( $item, $to_encoding, $from_encoding );
		}
		return $new_array;
	}
}

?>
