<?php
/**
* ǡǥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class charcoal_DefaultDataModel implements charcoal_IDataModel
{
	private $_class_name;
	private $_class_vars;
	private $_annotations;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_class_name = get_class($this);
		$this->_class_vars = get_class_vars($this->_class_name);

		$this->_annotation_list = array();
		foreach( $this->_class_vars as $key => $var ){
			$this->_annotations[$key] = self::_parseAnnotation( $key, $var );
		}
	}

	/*
	 *	Υơѡ
	 */
	private static function _parseAnnotation( $field, $annotations )
	{
		$phrase_list = explode( ' ', $annotations );

		$annotation_list = array();

		foreach( $phrase_list as $phrase ){
			if ( strpos($phrase,'@') === 0 ){
				// :ޤǤΥơ̾
				$phrase = substr($phrase,1);
				$pos = strpos($phrase,':');
				if ( $pos === false ){
					// ͤȥѥ᡼Ϥʤ
					$name = $phrase;
					$value = NULL;
					$param = NULL;
				}
				else{
					// ͤȥѥ᡼ʬ
					$name = substr($phrase,0,$pos);
					$value_and_params = substr($phrase,$pos+1);
					$open = strpos($value_and_params,'(');
					$close = strpos($value_and_params,')');
					// ѥ᡼뤫
					if ( $open === false && $close === false ){
						// ѥ᡼ʤ
						$value = $value_and_params;
						$param = NULL;
					}
					else if ( $open > 0 && $close > 0 ){
						// ѥ᡼
						$value = substr($value_and_params,0,$open);
						$param = substr($value_and_params,$open+1,$close-$open-1);
					}
					else{
						// Υơեޥå㳰
						throw new charcoal_DataModelAnnotaionException( $field, $name, 'illegal format' );
					}
				}
				// Υơɲ
				$annotation_list[$name] = new charcoal_DataModelAnnotation( $name, $value, $param );
			}
		}

		return $annotation_list;
	}

	/*
	 *	ơ֥̾
	 */
	public function getTableName()
	{
		if ( property_exists($this,'___table_name') ){
			$table_name = $this->___table_name;
		}
		else{
			$table_name = $this->_class_name;
		}
		return $table_name;
	}

	/*
	 *   ץ饤ޥꥭե̾
	 */
	public function getPrimaryKeyField()
	{
		$vars = $this->_class_vars;

		foreach( $vars as $key => $var ){
			$var = strtolower($var);
			$pos = strpos( $var, '@pk' );
			if ( false !== $pos ){
				return $key;
			}
		}

		throw new charcoal_DataModelException( $class_name, 'no primary key' );
	}

	/*
	 *   ե̾
	 */
	public function getFieldList()
	{
		$vars = $this->_class_vars;

		$fields = array();
		foreach( $vars as $key => $var ){
			if ( strpos($key,'___') === 0 ){
				// ___ǻϤޤץѥƥϥե̾ǤϤʤ
				continue;
			}
			$fields[] = $key;
		}

		return $fields;
	}

	/*
	 *   Υơ
	 */
	public function getAnnotation( $field, $annotation_name )
	{
		if ( !isset($this->_annotations[$field]) ){
			return NULL;
		}
		$annotation_list = $this->_annotations[$field];
		if ( !isset($annotation_list[$annotation_name]) ){
			return NULL;
		}
		return $annotation_list[$annotation_name];
	}

}
