<?php
/**
* HTTPꥯȤåפ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_Request 
{
	var $_get;
	var $_post;
	var $_url;

	const TYPE_GET      = "get";
	const TYPE_POST     = "post";
	const TYPE_MIXED    = "mixed";

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_get  = $_GET;
		$this->_post = $_POST;

		$url_string = "http://" . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];

		$this->_url = new charcoal_URL($url_string);

		unset( $_POST );
		unset( $_GET );
	}

	/*
	 *    URL
	 */
	public function getURL()
	{
		return $this->_url;
	}

	/*
	 *    
	 */
	public function getKeys( $type = self::TYPE_MIXED )
	{
		switch ( $type ){
		case self::TYPE_GET:
			return array_keys( $this->_get );
			break;
		case self::TYPE_POST:
			return array_keys( $this->_post );
			break;
		case self::TYPE_MIXED:
			return array_keys( array_merge($this->_get,$this->_post) );
			break;
		}
		return NULL;
	}

	/*
	 *    ѥ᡼
	 */
	public function get( $key, $type = self::TYPE_MIXED )
	{
		switch ( $type ){
		case self::TYPE_GET:
			return isset( $this->_get[$key] ) ? $this->_get[$key] : NULL;
			break;
		case self::TYPE_POST:
			return isset( $this->_post[$key] ) ? $this->_post[$key] : NULL;
			break;
		case self::TYPE_MIXED:
			if ( isset($this->_get[$key]) ){
				return $this->_get[$key];
			}
			if ( isset($this->_post[$key]) ){
				return $this->_post[$key];
			}
			return NULL;
			break;
		}
		return NULL;
	}

	/*
	 *    ѥ᡼
	 */
	public function set( $key, $value )
	{
		$this->_data[ $key ] = $value;
	}

	/*
	 * 
	 */
	public function dump()
	{
		System::dumpArray( $this->_data );
	}
}
