<?php
/**
* ⥸塼륰դ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_ModuleGraph 
{
	var $_module_graph;
	var $_current_node;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_current_node = NULL;
		$this->_module_graph = array();
	}

	/*
	 * Ρ̾
	 */
	public function getNodeNames()
	{
		return array_keys( $this->_module_graph );
	}

	/*
	 * Ρ̾бΡɤ
	 */
	public function getNode( $node_name )
	{
		return $this->_module_graph[ $node_name ];
	}

	/*
	 * startΡɤ¹Ԥ򳫻Ϥ
	 */
	public function start()
	{
		$start_node = "start";

		log_info( "system",  "⥸塼륰դθߥΡɤ[$start_node]ꤷޤ", __FILE__, __LINE__ );

		$this->_current_node = $this->_module_graph[ $start_node ];
	}

	/*
	 * ߤΥΡɤ뤫
	 */
	public function hasCurrentNode()
	{
		return ($this->_current_node != NULL);
	}

	/*
	 * ߤΥΡ
	 */
	public function getCurrentNode()
	{
		return $this->_current_node;
	}

	/*
	 * Ρɤܤ
	 */
	public function moveNext( $transition_key )
	{
		// ΥΡ̾
		$next_node_name = $this->_current_node->getNextNode( $transition_key );

		log_info( "system",  "ΥΡ̾[$next_node_name]Ǥ", __FILE__, __LINE__ );

		// 褬̤ʤ㳰
		if ( $next_node_name == NULL ){
			throw new charcoal_ModuleGraphTransitionException( $this->_current_node->getNodeName(), $transition_key );
		}

		// ߤΥΡɤ򹹿
		$this->_current_node = $this->_module_graph[ "$next_node_name" ];

//print "node_name:" . System::arrayToString( $this->_module_graph ) . "<BR>";
//var_dump( $this->_module_graph );

		// ߤΥΡɤֵ
		return $this->_current_node;
	}

	/*
	 * ⥸塼륰դ
	 */
	public function build( charcoal_Config $config, charcoal_ProcedureContext $context )
	{
		log_info( "system",  "⥸塼륰դιۤ򳫻Ϥޤ", __FILE__, __LINE__ );

		$this->_current_node = NULL;
		$this->_module_graph = array();

		// Ρ̾
		$node_name_list= $config->getArray( "graph_nodes" );

		if ( !$node_name_list ) {
			throw new charcoal_ModuleGraphConfigException( "graph_nodes", "mandatory" );
		}

		// ƥΡɤΥ⥸塼ɤ߹
		foreach( $node_name_list as $node_name => $node_data )
		{
			log_info( "system",  "Ρ[$node_name]ɤ߹ߤޤ", __FILE__, __LINE__ );
			if ( !$node_data ) {
				throw new charcoal_ModuleGraphConfigException( "graph_nodes/$node_name", "mandatory" );
			}

			// եΡɤ
			$graph_node = new charcoal_ModuleGraphNode();
			$graph_node->create( $node_name, $node_data );

			// ⥸塼륰դ˥եΡɤɲ
			$this->_module_graph[ $node_name ] = $graph_node;
		}

		log_info( "system",  "⥸塼륰դιۤλޤ", __FILE__, __LINE__ );
	}
}
