<?php
/**
* ̥åȥݡͥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_db_ResultSetLogger implements charcoal_IComponent
{
	var $_first_row;
	var $_column_size;
	var $_valid;
	var $_encoding;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_column_size = 20;
	}

	/*
	 * ݡͥ̾
	 */
	public function getComponentName()
	{
		return "ResultSetLogger Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function init( charcoal_Config $config )
	{
		$this->_column_size   = $config->getString( 'column_size' );
		$this->_valid         = $config->getBoolean( 'valid' );

		$this->_encoding = charcoal_Profile::getString( 'DB_CODE' );
	}

	/*
	 * ϳ
	 */
	public function start()
	{
		$this->_first_row = TRUE;
	}

	/*
	 *	ԾʺǽιԤξϥإåˢ$rowϢ
	 */
	public function logRowInfoAssoc( $row )
	{
		// եDB_ROWLOGGERͭǤʤϲ⤷ʤ
		if ( !$this->_valid ){
			return;
		}

		// 󥳡ǥѴ
		$conv = new EncodingConverter( i(EncodingConverter::DB_TO_LOG) );

		$col_size = $this->_column_size;
		$num_cols = count( $row );

		if ( $this->_first_row ){

			// ǽι
			$msg = "";
			foreach( $row as $key => $value ){
				$msg .= substr( $key . str_repeat(" ",$col_size), 0, $col_size );
			}
			log_info( "sql", $msg, __FILE__, __LINE__ );

			// 
			$msg = str_repeat( str_repeat("-",$col_size), $num_cols );
			log_info( "sql", $msg, __FILE__, __LINE__  );

			$this->_first_row = FALSE;
		}

		// Ծ
		$msg = "";
		foreach( $row as $key => $value ){
			$value .= str_repeat( " ", $col_size );
			$msg .= mb_strimwidth ( $value, 0, $col_size, " ", "UTF-8" );
		}
		log_info( "sql", $msg, __FILE__, __LINE__, $conv );
	}
}
