/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import java.util.Arrays;

class ApiMethodAnnotationConfig {
    private final ApiMethodConfig config;

    public ApiMethodAnnotationConfig(ApiMethodConfig config) {
        this.config = config;
    }

    public ApiMethodConfig getConfig() {
        return this.config;
    }

    public void setNameIfNotEmpty(String name) {
        if (name != null && !name.isEmpty()) {
            this.config.setName(name);
        }
    }

    public void setPathIfNotEmpty(String path) {
        if (path != null && !path.isEmpty()) {
            this.config.setPath(path);
        }
    }

    public void setHttpMethodIfNotEmpty(String httpMethod) {
        if (httpMethod != null && !httpMethod.isEmpty()) {
            this.config.setHttpMethod(httpMethod);
        }
    }

    public void setAuthLevelIfSpecified(AuthLevel authLevel) {
        if (authLevel != AuthLevel.UNSPECIFIED) {
            this.config.setAuthLevel(authLevel);
        }
    }

    public void setScopesIfSpecified(String[] scopes) {
        if (!AnnotationUtil.isUnspecified(scopes)) {
            this.config.setScopes(Arrays.asList(scopes));
        }
    }

    public void setAudiencesIfSpecified(String[] audiences) {
        if (!AnnotationUtil.isUnspecified(audiences)) {
            this.config.setAudiences(Arrays.asList(audiences));
        }
    }

    public void setClientIdsIfSpecified(String[] clientIds) {
        if (!AnnotationUtil.isUnspecified(clientIds)) {
            this.config.setClientIds(Arrays.asList(clientIds));
        }
    }
}

