/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static <T extends Annotation> T getParameterAnnotation(Method method, int i, Class<T> annotationType) {
        for (Annotation annotation : method.getParameterAnnotations()[i]) {
            if (annotation.annotationType() != annotationType) continue;
            return (T)annotation;
        }
        return null;
    }

    public static Annotation getParameterAnnotationWithName(Method method, int i, String annotationName, Class<?> valueType) {
        for (Annotation annotation : method.getParameterAnnotations()[i]) {
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            try {
                if (valueType != null && !annotation.getClass().getMethod("value", new Class[0]).getReturnType().equals(valueType)) continue;
                return annotation;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Annotation getNamedParameter(Method method, int i, Class<? extends Annotation> internalNamedType) {
        Annotation annotation = AnnotationUtil.getParameterAnnotation(method, i, internalNamedType);
        if (annotation == null) {
            annotation = AnnotationUtil.getParameterAnnotationWithName(method, i, "javax.inject.Named", String.class);
        }
        return annotation;
    }

    public static Annotation getNullableParameter(Method method, int i, Class<? extends Annotation> internalNullableType) {
        Annotation annotation = AnnotationUtil.getParameterAnnotation(method, i, internalNullableType);
        if (annotation == null) {
            annotation = AnnotationUtil.getParameterAnnotationWithName(method, i, "javax.annotation.Nullable", null);
        }
        return annotation;
    }

    public static boolean isUnspecified(String[] values) {
        return values == null || values.length == 1 && values[0].equals("_UNSPECIFIED_LIST_STRING_VALUE");
    }
}

