/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.User;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class WebApisUserService {
    private static final Logger logger = Logger.getLogger(WebApisUserService.class.getName());
    @VisibleForTesting
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    @VisibleForTesting
    protected static final String[] ALLOWED_AUTH_SCHEMES = new String[]{"OAuth", "Bearer"};
    @VisibleForTesting
    protected static final String[] OAUTH2_TOKEN_PREFIXES = new String[]{"ya29.", "1/"};
    @VisibleForTesting
    protected static final List<String> SKIP_CLIENT_ID_CHECK_LIST = ImmutableList.of((Object)"*");
    @VisibleForTesting
    protected static final String[] BEARER_TOKEN_PARAMETER_NAMES = new String[]{"access_token", "bearer_token"};
    private static final String[] CLIENT_TAGS = new String[]{"cid", "azp"};
    private static final String AUDIENCE_TAG = "aud";
    private static final String EMAIL_TAG = "email";
    private final GoogleIdTokenVerifier verifier;
    private final boolean clientIdWhitelistEnabled;
    private final HttpRequestFactory httpRequestFactory;

    WebApisUserService(boolean clientIdWhitelistEnabled) {
        GoogleIdTokenVerifier.Builder builder = new GoogleIdTokenVerifier.Builder(this.getTransport(), new JacksonFactory());
        this.verifier = builder.build();
        this.clientIdWhitelistEnabled = clientIdWhitelistEnabled;
        this.httpRequestFactory = this.getTransport().createRequestFactory(new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest request) {
                request.setParser(new JsonObjectParser(new JacksonFactory()));
            }
        });
    }

    private HttpTransport getTransport() {
        if (SystemProperty.environment.value() == SystemProperty.Environment.Value.Production) {
            return new UrlFetchTransport();
        }
        return new NetHttpTransport();
    }

    @VisibleForTesting
    protected String matchAuthScheme(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        for (String authScheme : ALLOWED_AUTH_SCHEMES) {
            if (!authHeader.startsWith(authScheme)) continue;
            return authScheme;
        }
        return null;
    }

    public User getCurrentUser(HttpServletRequest request, ApiMethodConfig methodConfig) {
        return this.getCurrentUser(this.getAuthToken(request), methodConfig.getScopes(), methodConfig.getAudiences(), methodConfig.getClientIds(), SystemProperty.environment.value());
    }

    @VisibleForTesting
    User getCurrentUser(String token, List<String> allowedScopes, List<String> allowedAudiences, List<String> allowedClientIds) {
        return this.getCurrentUser(token, allowedScopes, allowedAudiences, allowedClientIds, SystemProperty.Environment.Value.Production);
    }

    @VisibleForTesting
    User getCurrentUser(String token, List<String> allowedScopes, List<String> allowedAudiences, List<String> allowedClientIds, SystemProperty.Environment.Value env) {
        logger.log(Level.FINE, "token={0}", token);
        logger.log(Level.FINE, "allowedScopes={0}", allowedScopes);
        logger.log(Level.FINE, "allowedAudiences={0}", allowedAudiences);
        logger.log(Level.FINE, "allowedClientIds={0}", allowedClientIds);
        if (token == null || token.trim().isEmpty()) {
            return null;
        }
        if (this.isIdToken(token)) {
            String idTokenEmail = this.getIdTokenEmail(token, allowedAudiences, allowedClientIds, env);
            logger.log(Level.INFO, "getCurrentUser: IdToken; email={0}", idTokenEmail);
            return idTokenEmail == null ? null : new User(idTokenEmail, "");
        }
        for (String allowedScope : allowedScopes) {
            try {
                String clientId = env == SystemProperty.Environment.Value.Development ? this.getOAuth2ClientIdDev(token) : this.getOAuth2ClientId(allowedScope);
                if (!this.isClientIdAllowed(clientId, allowedClientIds, true)) {
                    logger.log(Level.WARNING, "getCurrentUser: clientId {0} not allowed", clientId);
                    return null;
                }
            }
            catch (OAuthRequestException e) {
                logger.log(Level.INFO, "getCurrentUser: AccessToken; Tried and failed to get client id for scope '" + allowedScope + "'", e);
                continue;
            }
            try {
                User user = this.getOAuth2User(allowedScope);
                logger.log(Level.INFO, "getCurrentUser: AccessToken; user={0}", user);
                return user;
            }
            catch (OAuthRequestException e) {
                logger.log(Level.INFO, "getCurrentUser: AccessToken; Tried and failed to get user for scope '" + allowedScope + "'", e);
            }
        }
        logger.info("getCurrentUser: AccessToken; scope not allowed");
        return null;
    }

    @VisibleForTesting
    String getAuthToken(HttpServletRequest request) {
        String token = this.getAuthTokenFromHeader(request.getHeader(HEADER_AUTHORIZATION));
        if (token == null) {
            token = this.getAuthTokenFromQueryParameters(request);
        }
        return token;
    }

    private String getAuthTokenFromQueryParameters(HttpServletRequest request) {
        for (String parameterName : BEARER_TOKEN_PARAMETER_NAMES) {
            String token = request.getParameter(parameterName);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    private String getAuthTokenFromHeader(String authHeader) {
        String authScheme = this.matchAuthScheme(authHeader);
        if (authScheme == null) {
            return null;
        }
        return authHeader.substring(authScheme.length() + 1);
    }

    boolean isIdToken(String token) {
        String strippedToken = token.trim().replaceFirst("^['\"]", "");
        for (String prefix : OAUTH2_TOKEN_PREFIXES) {
            if (!strippedToken.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    GoogleIdToken verifyTokenInternal(String token) {
        try {
            return this.verifier.verify(token);
        }
        catch (GeneralSecurityException e) {
            logger.warning("getCurrentUser: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            logger.warning("getCurrentUser: " + e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.warning("getCurrentUser: " + e.getMessage());
            return null;
        }
    }

    private String getIdTokenEmail(String token, List<String> allowedAudiences, List<String> allowedClientIds, SystemProperty.Environment.Value env) {
        GoogleIdToken idToken = this.verifyTokenInternal(token);
        if (idToken == null) {
            logger.warning("getCurrentUser: idToken=null");
            return null;
        }
        if (!this.isClientIdAllowed(allowedClientIds, idToken) || !this.isAudienceAllowed(allowedAudiences, idToken)) {
            return null;
        }
        return this.extractUser(idToken);
    }

    private boolean isAudienceAllowed(List<String> allowedAudiences, GoogleIdToken idToken) {
        String audience = this.extractAudience(idToken);
        if (this.isEmptyOrWhitespace(audience)) {
            logger.warning("Token contained no audience: " + idToken.getPayload());
            return false;
        }
        if (allowedAudiences != null && allowedAudiences.size() != 0) {
            for (String allowedAudience : allowedAudiences) {
                if (!audience.equals(allowedAudience)) continue;
                return true;
            }
        }
        if (audience.equals(this.extractClientId(idToken))) {
            return true;
        }
        logger.warning("Audience in token was not allowed: " + audience);
        return false;
    }

    private String extractAudience(GoogleIdToken idToken) {
        return (String)idToken.getPayload().get(AUDIENCE_TAG);
    }

    private String extractClientId(GoogleIdToken idToken) {
        for (String clientTag : CLIENT_TAGS) {
            String value = (String)idToken.getPayload().get(clientTag);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String extractUser(GoogleIdToken idToken) {
        return (String)idToken.getPayload().get(EMAIL_TAG);
    }

    private boolean isClientIdAllowed(List<String> allowedClientIds, GoogleIdToken idToken) {
        String clientId = this.extractClientId(idToken);
        if (this.isEmptyOrWhitespace(clientId)) {
            logger.warning("Token contained no clientId: " + idToken.getPayload());
            return false;
        }
        if (!this.isClientIdAllowed(clientId, allowedClientIds, false)) {
            logger.warning("ClientId in token was not allowed: " + clientId);
            return false;
        }
        return true;
    }

    private boolean isClientIdAllowed(String clientId, List<String> allowedClientIds, boolean allowSkipClientIdCheck) {
        if (!this.clientIdWhitelistEnabled) {
            logger.info("Client allowed because the whitelist is disabled");
            return true;
        }
        if (allowedClientIds == null || allowedClientIds.size() == 0) {
            return false;
        }
        if (allowSkipClientIdCheck && allowedClientIds.equals(SKIP_CLIENT_ID_CHECK_LIST)) {
            return true;
        }
        for (String allowedClientId : allowedClientIds) {
            if (this.isEmptyOrWhitespace(allowedClientId) || !allowedClientId.equals(clientId)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyOrWhitespace(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().isEmpty();
    }

    @VisibleForTesting
    User getOAuth2User(String scope) throws OAuthRequestException {
        return OAuthServiceFactory.getOAuthService().getCurrentUser(scope);
    }

    @VisibleForTesting
    String getOAuth2ClientId(String scope) throws OAuthRequestException {
        return OAuthServiceFactory.getOAuthService().getClientId(scope);
    }

    @VisibleForTesting
    String getOAuth2ClientIdDev(String token) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setAuthorization("Bearer " + token);
            GenericUrl url = new GenericUrl("https://www.google.com/accounts/AuthSubTokenInfo");
            HttpRequest request = this.httpRequestFactory.buildGetRequest(url).setHeaders(headers);
            HttpResponse response = request.execute();
            Properties properties = new Properties();
            properties.load(response.getContent());
            return (String)properties.get("Target");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to retrieve clientId from access token", e);
            return null;
        }
    }
}

