/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.RecordingData;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class RecordingFuture
implements Future<byte[]> {
    final Future<byte[]> wrappedFuture;
    private final RecordingData recordingData;
    private final Recorder recorder;
    private final ApiProxy.Environment environment;
    private final byte[] request;

    public static RecordingFuture of(Future<byte[]> wrappedFuture, RecordingData recordingData, Recorder recorder, ApiProxy.Environment environment, byte[] request) {
        if (wrappedFuture instanceof ApiProxy.ApiResultFuture) {
            return new ExtendedFuture(wrappedFuture, recordingData, recorder, environment, request);
        }
        return new RecordingFuture(wrappedFuture, recordingData, recorder, environment, request);
    }

    public byte[] getRequest() {
        return this.request;
    }

    private RecordingFuture(Future<byte[]> wrappedFuture, RecordingData recordingData, Recorder recorder, ApiProxy.Environment environment, byte[] request) {
        this.wrappedFuture = wrappedFuture;
        this.recordingData = recordingData;
        this.environment = environment;
        this.recorder = recorder;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean bl = this.wrappedFuture.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.maybeRecordStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get() throws InterruptedException, ExecutionException {
        try {
            byte[] byArray = this.wrappedFuture.get();
            return byArray;
        }
        finally {
            this.maybeRecordStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            byte[] byArray = this.wrappedFuture.get(timeout, unit);
            return byArray;
        }
        finally {
            this.maybeRecordStats();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.wrappedFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.wrappedFuture.isDone();
    }

    public RecordingData getRecordingData() {
        return this.recordingData;
    }

    private void maybeRecordStats() {
        if (!this.recordingData.isProcessed()) {
            this.recorder.processAsyncRpc(this, this.environment);
        }
    }

    private static class ExtendedFuture
    extends RecordingFuture
    implements ApiProxy.ApiResultFuture<byte[]> {
        private final ApiProxy.ApiResultFuture<byte[]> extendedFuture;

        private ExtendedFuture(Future<byte[]> wrappedFuture, RecordingData recordingData, Recorder recorder, ApiProxy.Environment environment, byte[] request) {
            super(wrappedFuture, recordingData, recorder, environment, request);
            this.extendedFuture = (ApiProxy.ApiResultFuture)wrappedFuture;
        }

        public long getCpuTimeInMegaCycles() {
            return this.extendedFuture.getCpuTimeInMegaCycles();
        }

        public long getWallclockTimeInMillis() {
            return this.extendedFuture.getWallclockTimeInMillis();
        }
    }
}

