/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractSortedMultiset;
import com.google.appengine.repackaged.com.google.common.collect.BoundType;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.collect.SortedMultiset;
import java.util.Comparator;
import java.util.Iterator;

@GwtCompatible
@GoogleInternal
final class EmptySortedMultiset<E>
extends AbstractSortedMultiset<E> {
    private static final EmptySortedMultiset<Comparable> NATURAL_INSTANCE = new EmptySortedMultiset(Ordering.natural());

    static <E extends Comparable> SortedMultiset<E> natural() {
        return NATURAL_INSTANCE;
    }

    EmptySortedMultiset(Comparator<? super E> comparator) {
        super(comparator);
    }

    @Override
    public SortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        return this;
    }

    @Override
    public SortedMultiset<E> tailMultiset(E fromElement, BoundType boundType) {
        return this;
    }

    @Override
    Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        return Iterators.emptyIterator();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        return Iterators.emptyIterator();
    }

    @Override
    int distinctElements() {
        return 0;
    }

    @Override
    public int add(E element, int occurrences) {
        Preconditions.checkNotNull(element);
        throw new IllegalArgumentException();
    }

    @Override
    public int remove(Object element, int occurrences) {
        return 0;
    }

    @Override
    public void clear() {
    }
}

