/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.Preconditions;
import com.google.apphosting.api.search.DocumentPb;

public class GeoPointChecker {
    public static final double MAXIMUM_NEGATIVE_LATITUDE = -90.0;
    public static final double MAXIMUM_POSITIVE_LATITUDE = 90.0;
    public static final double MAXIMUM_NEGATIVE_LONGITUDE = -180.0;
    public static final double MAXIMUM_POSITIVE_LONGITUDE = 180.0;

    public static double checkLatitude(double latitude) {
        Preconditions.checkArgument(-90.0 <= latitude && latitude <= 90.0, "latitude %f must be between %f and %f", latitude, -90.0, 90.0);
        return latitude;
    }

    public static double checkLongitude(double longitude) {
        Preconditions.checkArgument(-180.0 <= longitude && longitude <= 180.0, "longitude %f must be between %f and %f", longitude, -180.0, 180.0);
        return longitude;
    }

    public static DocumentPb.FieldValue.Geo checkValid(DocumentPb.FieldValue.Geo geoPb) {
        GeoPointChecker.checkLatitude(geoPb.getLat());
        GeoPointChecker.checkLongitude(geoPb.getLng());
        return geoPb;
    }
}

