/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

@GoogleInternal
public final class LongArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long[] list;
    private int length;

    @Deprecated
    public LongArray() {
        this.list = new long[4];
        this.length = 0;
    }

    @Deprecated
    public LongArray(int capacity) {
        this.list = new long[capacity];
        this.length = 0;
    }

    public LongArray(long[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new long[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private LongArray(long[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static LongArray newInstance(long ... array) {
        Preconditions.checkNotNull(array);
        return new LongArray(array, array.length);
    }

    @Deprecated
    @VisibleForTesting
    static LongArray newInstance(long[] array, int length) {
        Preconditions.checkNotNull(array);
        Preconditions.checkArgument(length >= 0 && length <= array.length);
        return new LongArray(array, length);
    }

    public int size() {
        return this.length;
    }

    public long get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void set(int i, long x) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = x;
    }

    public void add(long x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    @VisibleForTesting
    void add(long[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(LongArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    @VisibleForTesting
    void removeLast() {
        X.assertTrue(this.length > 0);
        --this.length;
    }

    public void removeFast(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = this.list[this.length - 1];
        this.removeLast();
    }

    public int indexOf(long element) {
        for (int i = 0; i < this.length; ++i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    private void ensureCapacity(int n) {
        if (this.list.length < n) {
            int newSize = this.list.length * 2;
            if (newSize < n) {
                newSize = n;
            }
            long[] copy = new long[newSize];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public long[] rep() {
        return this.list;
    }

    @VisibleForTesting
    void resize(int n) {
        X.assertTrue(n >= 0);
        this.ensureCapacity(n);
        this.length = n;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    @VisibleForTesting
    void swap(LongArray other) {
        int tmpLength = this.length;
        this.length = other.length;
        other.length = tmpLength;
        long[] tmpList = this.list;
        this.list = other.list;
        other.list = tmpList;
    }

    public long[] toArray() {
        long[] copy = new long[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }

    @VisibleForTesting
    long[] subArray(int start, int len) {
        X.assertTrue(start >= 0);
        X.assertTrue(start + len <= this.length);
        long[] copy = new long[len];
        System.arraycopy(this.list, start, copy, 0, len);
        return copy;
    }

    @VisibleForTesting
    void copy(long[] dest, int len, int srcPos, int destPos) {
        X.assertTrue(srcPos >= 0);
        X.assertTrue(destPos >= 0);
        X.assertTrue(len >= 0);
        X.assertTrue(srcPos + len <= this.length);
        X.assertTrue(destPos + len <= dest.length);
        System.arraycopy(this.list, srcPos, dest, destPos, len);
    }
}

