/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Log2;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.logging.Logger;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

@Deprecated
@GoogleInternal
class LogWriter
implements Logger {
    private static final String LEVEL_IDS = "DIX";
    static final int DEFAULT_THRESHOLD = 0;
    private int threshold;
    SimpleDateFormat dateFormatter = null;
    Writer writer = null;
    ThreadLocal<String> threadTagMap = new ThreadLocal();

    LogWriter() {
    }

    public LogWriter(Writer writer) {
        this.writer = writer;
        this.dateFormatter = new SimpleDateFormat("yyMMdd HH:mm:ss.SSS");
        this.threshold = 0;
    }

    public void setThreshold(int level) {
        if (level < 0 || level > 3) {
            throw new RuntimeException("RotatingLog#setThreshold(int) : invalid threshold value: " + level);
        }
        this.threshold = level;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void logDebug(String msg) {
        this.write(0, msg);
    }

    public void logEvent(String msg) {
        this.write(1, msg);
    }

    public void logTimedEvent(String msg, long start, long end) {
        this.write(1, end - start + " ms.: " + msg);
    }

    public void setErrorEmail(String emailAddr) {
    }

    public void logException(Throwable t) {
        this.logException(t, "");
    }

    public void logException(Throwable t, String msg) {
        String errorMessage = t.getMessage();
        if (errorMessage != null) {
            msg = msg + ": " + errorMessage;
        }
        this.write(2, msg + "\n" + Log2.getExceptionTrace(t));
    }

    public void logSevereException(Throwable t) {
        this.logSevereException(t, "");
    }

    public void logSevereException(Throwable t, String msg) {
        String errorMessage = t.getMessage();
        if (errorMessage != null) {
            msg = msg + ": " + errorMessage;
        }
        this.write(2, msg + "\n" + Log2.getExceptionTrace(t));
    }

    public void logError(String msg) {
        this.write(2, msg + "\n" + Log2.getExceptionTrace(new LoggedError()));
    }

    protected synchronized void write(int level, String msg) {
        if (level < this.threshold) {
            return;
        }
        String threadTag = this.getThreadTag();
        threadTag = threadTag == null ? "" : threadTag + " ";
        int charPrefix = LEVEL_IDS.charAt(level);
        StringBuffer sb = new StringBuffer(1000);
        for (String token : Splitter.on('\n').omitEmptyStrings().split(msg)) {
            if (this.dateFormatter != null) {
                sb.append(this.dateFormatter.format(new Date()));
                sb.append(':');
            }
            sb.append((char)charPrefix);
            sb.append(' ');
            sb.append(threadTag);
            sb.append(token);
            sb.append("\n");
            charPrefix = 32;
        }
        try {
            this.writer.write(sb.toString());
            this.writer.flush();
        }
        catch (IOException ioE) {
            System.err.println("LogWriter#write(int, String) : error in writing to log!\n Exception thrown: " + ioE.getMessage() + "\nlog entry: " + msg);
        }
    }

    public String getThreadTag() {
        return this.threadTagMap.get();
    }

    public void setThreadTag(String s) {
        this.threadTagMap.set(s);
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class LoggedError
    extends Throwable {
        private static final long serialVersionUID = 1L;

        LoggedError() {
        }
    }
}

