/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import java.io.IOException;

public class GoogleRefreshTokenRequest
extends RefreshTokenRequest {
    public GoogleRefreshTokenRequest(HttpTransport transport, JsonFactory jsonFactory, String refreshToken, String clientId, String clientSecret) {
        super(transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), refreshToken);
        this.setClientAuthentication(new ClientParametersAuthentication(clientId, clientSecret));
    }

    @Override
    public GoogleRefreshTokenRequest setRequestInitializer(HttpRequestInitializer requestInitializer) {
        return (GoogleRefreshTokenRequest)super.setRequestInitializer(requestInitializer);
    }

    @Override
    public GoogleRefreshTokenRequest setTokenServerUrl(GenericUrl tokenServerUrl) {
        return (GoogleRefreshTokenRequest)super.setTokenServerUrl(tokenServerUrl);
    }

    @Override
    public GoogleRefreshTokenRequest setScopes(String ... scopes) {
        return (GoogleRefreshTokenRequest)super.setScopes(scopes);
    }

    @Override
    public GoogleRefreshTokenRequest setScopes(Iterable<String> scopes) {
        return (GoogleRefreshTokenRequest)super.setScopes((Iterable)scopes);
    }

    @Override
    public GoogleRefreshTokenRequest setGrantType(String grantType) {
        return (GoogleRefreshTokenRequest)super.setGrantType(grantType);
    }

    @Override
    public GoogleRefreshTokenRequest setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
        return (GoogleRefreshTokenRequest)super.setClientAuthentication(clientAuthentication);
    }

    @Override
    public GoogleRefreshTokenRequest setRefreshToken(String refreshToken) {
        return (GoogleRefreshTokenRequest)super.setRefreshToken(refreshToken);
    }

    @Override
    public GoogleTokenResponse execute() throws IOException {
        return this.executeUnparsed().parseAs(GoogleTokenResponse.class);
    }
}

