/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.response.AbstractResultWriter;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.repackaged.com.google.api.client.util.DateTime;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerator;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonProcessingException;
import com.google.appengine.repackaged.org.codehaus.jackson.Version;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonSerializer;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.map.SerializerProvider;
import com.google.appengine.repackaged.org.codehaus.jackson.map.annotate.JsonSerialize;
import com.google.appengine.repackaged.org.codehaus.jackson.map.module.SimpleModule;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class ServletResponseResultWriter
extends AbstractResultWriter {
    private final HttpServletResponse servletResponse;
    private final ObjectMapper objectMapper;

    public ServletResponseResultWriter(HttpServletResponse servletResponse) {
        this(servletResponse, null);
    }

    public ServletResponseResultWriter(HttpServletResponse servletResponse, SimpleModule jsonParserModule) {
        this.servletResponse = servletResponse;
        this.objectMapper = ObjectMapperUtil.createStandardObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.objectMapper.registerModule(ServletResponseResultWriter.getWriteLongAsStringModule());
        this.objectMapper.registerModule(ServletResponseResultWriter.getWriteDateAsStringModule());
        this.objectMapper.registerModule(ServletResponseResultWriter.getWriteBlobAsBase64Module());
        if (jsonParserModule != null) {
            this.objectMapper.registerModule(jsonParserModule);
        }
    }

    @Override
    public void write(Object response) throws IOException {
        if (response == null) {
            this.write(204, null, null);
        } else {
            this.write(200, null, ObjectMapperUtil.writeValueAsString(this.objectMapper, this.wrapCollection(response)));
        }
    }

    @Override
    public void writeError(ServiceException e) throws IOException {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error_message", e.getMessage());
        this.write(e.getStatusCode(), e.getHeaders(), ObjectMapperUtil.writeValueAsString(this.objectMapper, errors));
    }

    protected void write(int status, Map<String, String> headers, String content) throws IOException {
        this.servletResponse.setStatus(status);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.servletResponse.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (content != null) {
            this.servletResponse.setContentType("application/json; charset=UTF-8");
            this.servletResponse.setContentLength(content.getBytes("UTF-8").length);
            this.servletResponse.getWriter().write(content);
        }
    }

    private static SimpleModule getWriteLongAsStringModule() {
        JsonSerializer<Long> longSerializer = new JsonSerializer<Long>(){

            @Override
            public void serialize(Long value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(value.toString());
            }
        };
        SimpleModule writeLongAsStringModule = new SimpleModule("writeLongAsStringModule", new Version(1, 0, 0, null));
        writeLongAsStringModule.addSerializer(Long.TYPE, longSerializer);
        writeLongAsStringModule.addSerializer(Long.class, longSerializer);
        return writeLongAsStringModule;
    }

    private static SimpleModule getWriteDateAsStringModule() {
        JsonSerializer<Date> dateSerializer = new JsonSerializer<Date>(){

            @Override
            public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(new DateTime(value).toStringRfc3339());
            }
        };
        SimpleModule writeDateAsStringModule = new SimpleModule("writeDateAsStringModule", new Version(1, 0, 0, null));
        writeDateAsStringModule.addSerializer(Date.class, dateSerializer);
        return writeDateAsStringModule;
    }

    private static SimpleModule getWriteBlobAsBase64Module() {
        JsonSerializer<Blob> dateSerializer = new JsonSerializer<Blob>(){

            @Override
            public void serialize(Blob value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                byte[] bytes = value.getBytes();
                jgen.writeBinary(bytes, 0, bytes.length);
            }
        };
        SimpleModule writeBlobAsBase64Module = new SimpleModule("writeBlobAsBase64Module", new Version(1, 0, 0, null));
        writeBlobAsBase64Module.addSerializer(Blob.class, dateSerializer);
        return writeBlobAsBase64Module;
    }
}

