/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.request;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.WebApisUserService;
import com.google.api.server.spi.request.AbstractParamReader;
import com.google.api.server.spi.request.RequestUtil;
import com.google.api.server.spi.response.BadRequestException;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.api.client.util.DateTime;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParser;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonProcessingException;
import com.google.appengine.repackaged.org.codehaus.jackson.Version;
import com.google.appengine.repackaged.org.codehaus.jackson.map.DeserializationContext;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonDeserializer;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.map.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestParamReader
extends AbstractParamReader {
    private static final Logger logger = Logger.getLogger(ServletRequestParamReader.class.getName());
    private final HttpServletRequest servletRequest;
    private final ServletContext servletContext;
    private final ObjectMapper objectMapper;

    public ServletRequestParamReader(Method method, WebApisUserService userService, HttpServletRequest servletRequest, ServletContext servletContext, SimpleModule customModule) {
        super(method, userService);
        this.servletRequest = servletRequest;
        this.servletContext = servletContext;
        this.objectMapper = ObjectMapperUtil.createStandardObjectMapper();
        SimpleModule paramListModule = new SimpleModule("paramListModule", new Version(1, 0, 0, null));
        paramListModule.addDeserializer(Object[].class, new ParamListDeserializer());
        this.objectMapper.registerModule(paramListModule);
        SimpleModule dateModule = new SimpleModule("dateModule", new Version(1, 0, 0, null));
        dateModule.addDeserializer(Date.class, new DateDeserializer());
        this.objectMapper.registerModule(dateModule);
        SimpleModule blobModule = new SimpleModule("blobModule", new Version(1, 0, 0, null));
        blobModule.addDeserializer(Blob.class, new BlobDeserializer());
        this.objectMapper.registerModule(blobModule);
        if (customModule != null) {
            this.objectMapper.registerModule(customModule);
        }
    }

    @Override
    public Object[] read() throws BadRequestException {
        try {
            String requestBody = IoUtil.readStream((InputStream)this.servletRequest.getInputStream());
            logger.log(Level.FINE, "requestBody={}", requestBody);
            if (requestBody == null || requestBody.trim().isEmpty()) {
                return new Object[0];
            }
            Object[] params = this.objectMapper.readValue(requestBody, Object[].class);
            return params;
        }
        catch (UnsupportedEncodingException e) {
            throw new BadRequestException(e);
        }
        catch (JsonParseException e) {
            throw new BadRequestException(e);
        }
        catch (JsonMappingException e) {
            throw new BadRequestException(e);
        }
        catch (IOException e) {
            throw new BadRequestException(e);
        }
    }

    private class BlobDeserializer
    extends JsonDeserializer<Blob> {
        private BlobDeserializer() {
        }

        @Override
        public Blob deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
            return new Blob(jsonParser.getBinaryValue());
        }
    }

    private class DateDeserializer
    extends JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        @Override
        public Date deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonProcessingException, IOException {
            DateTime date = new DateTime(jsonParser.readValueAs(String.class));
            return new Date(date.getValue());
        }
    }

    private class ParamListDeserializer
    extends JsonDeserializer<Object[]> {
        private ParamListDeserializer() {
        }

        @Override
        public Object[] deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonProcessingException, IOException {
            JsonNode node = jsonParser.readValueAsTree();
            Method method = ServletRequestParamReader.this.getMethod();
            Class<?>[] paramTypes = method.getParameterTypes();
            Object[] params = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> type = paramTypes[i];
                if (type == User.class) {
                    params[i] = ServletRequestParamReader.this.getUser(ServletRequestParamReader.this.servletRequest);
                    logger.log(Level.FINE, "deserialize: User injected into param[{0}]", i);
                    continue;
                }
                if (type == HttpServletRequest.class) {
                    params[i] = ServletRequestParamReader.this.servletRequest;
                    logger.log(Level.FINE, "deserialize: HttpServletRequest injected into param[{0}]", i);
                    continue;
                }
                if (type == ServletContext.class) {
                    params[i] = ServletRequestParamReader.this.servletContext;
                    logger.log(Level.FINE, "deserialize: ServletContext {0} injected into param[{1}]", new Object[]{params[i], i});
                    continue;
                }
                Named name = RequestUtil.getParameterAnnotation(method, i, Named.class);
                if (name == null || name.value() == null || name.value().isEmpty()) {
                    params[i] = ServletRequestParamReader.this.objectMapper.readValue(node, type);
                    logger.log(Level.FINE, "deserialize: {0} {1} injected into unnamed param[{2}]", new Object[]{type, params[i], i});
                    continue;
                }
                JsonNode nodeValue = node.get(name.value());
                params[i] = nodeValue == null ? null : ServletRequestParamReader.this.objectMapper.readValue(nodeValue, type);
                logger.log(Level.FINE, "deserialize: {0} {1} injected into param[{2}] named {3}", new Object[]{type, params[i], i, name.value()});
            }
            return params;
        }
    }
}

