/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.SystemService;
import com.google.api.server.spi.WebApisUserService;
import com.google.api.server.spi.request.ParamReader;
import com.google.api.server.spi.request.ServletRequestParamReader;
import com.google.api.server.spi.response.BadRequestException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.server.spi.response.ResultWriter;
import com.google.api.server.spi.response.ServletResponseResultWriter;
import com.google.appengine.repackaged.org.codehaus.jackson.map.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SystemServiceServlet
extends HttpServlet {
    private static final Pattern PATH_PATTERN = Pattern.compile("/([^/]+)\\.([^/]+)");
    public static final String INIT_PARAM_SERVICES = "services";
    public static final String INIT_PARAM_RESTRICTED = "restricted";
    public static final String INIT_PARAM_ALLOWED_CLIENT_IDS = "allowedClientIds";
    public static final String HEADER_NAME_PEER = "X-Appengine-Peer";
    public static final String GOOGLE_PEER = "apiserving";
    private static final Logger logger = Logger.getLogger(SystemServiceServlet.class.getName());
    protected SystemService systemService;
    protected WebApisUserService userService;
    private boolean restricted;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config == null) {
            this.restricted = true;
            this.userService = new WebApisUserService(new HashSet<String>());
        } else {
            String restricted = config.getInitParameter(INIT_PARAM_RESTRICTED);
            this.restricted = restricted == null ? true : Boolean.valueOf(restricted);
            String allowedClientIds = config.getInitParameter(INIT_PARAM_ALLOWED_CLIENT_IDS);
            this.userService = new WebApisUserService(SystemServiceServlet.toSet(allowedClientIds, 5));
        }
        logger.log(Level.INFO, "SPI restricted: {0}", this.restricted);
        this.systemService = this.createSystemService(config);
    }

    private static Set<String> toSet(String csv, int limit) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (csv != null) {
            String[] values = csv.split(",");
            for (int i = 0; i < values.length && i < limit; ++i) {
                set.add(values[i].trim());
            }
        }
        return set;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getPathInfo();
        String[] pathParams = this.getPathParams(path);
        ResultWriter responseWriter = this.getResponseWriter(response);
        if (pathParams != null) {
            try {
                String serviceName = pathParams[0];
                String methodName = pathParams[1];
                this.execute(request, responseWriter, serviceName, methodName);
            }
            catch (ServiceException e) {
                responseWriter.writeError(e);
            }
        } else {
            responseWriter.writeError(new BadRequestException("missing /{Service}.{method}"));
        }
    }

    protected ParamReader getParamReader(Method method, HttpServletRequest request) {
        return new ServletRequestParamReader(method, this.userService, request, this.getServletContext(), this.getJsonParserModule());
    }

    protected ResultWriter getResponseWriter(HttpServletResponse response) {
        return new ServletResponseResultWriter(response, this.getJsonParserModule());
    }

    protected void execute(HttpServletRequest request, ResultWriter responseWriter, String serviceName, String methodName) throws ServiceException, IOException {
        logger.log(Level.FINE, "serviceName={0} methodName={1}", new Object[]{serviceName, methodName});
        if (this.isRequestRestricted(request.getHeader(HEADER_NAME_PEER))) {
            logger.info("SPI restricted and request denied");
            responseWriter.writeError(new NotFoundException("Not found"));
        } else {
            Method serviceMethod = this.systemService.resolveService(serviceName, methodName);
            logger.log(Level.FINE, "serviceMethod={0}", serviceMethod);
            ParamReader requestReader = this.getParamReader(serviceMethod, request);
            this.systemService.invokeServiceMethod(this.systemService.findService(serviceName), serviceMethod, requestReader, responseWriter);
        }
    }

    private String[] getPathParams(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return null;
    }

    protected SimpleModule getJsonParserModule() {
        return null;
    }

    protected SystemService createSystemService(ServletConfig config) throws ServletException {
        try {
            return new SystemService(config.getInitParameter(INIT_PARAM_SERVICES), this.getUserClassLoader(config));
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private ClassLoader getUserClassLoader(ServletConfig config) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        try {
            Class<?> contextClass = Class.forName("com.google.apphosting.utils.jetty.AppEngineWebAppContext$AppEngineServletContext");
            Method method = contextClass.getMethod("getClassLoader", new Class[0]);
            return (ClassLoader)method.invoke((Object)config.getServletContext(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    boolean isRequestRestricted(String peer) {
        return this.restricted && !GOOGLE_PEER.equals(peer);
    }
}

