/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.BackendService;
import com.google.api.server.spi.Objects;
import com.google.api.server.spi.Preconditions;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.request.ParamReader;
import com.google.api.server.spi.response.BadRequestException;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.ResultWriter;
import com.google.api.server.spi.response.UnauthorizedException;
import com.google.appengine.api.oauth.OAuthRequestException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemService {
    private static final Logger logger = Logger.getLogger(SystemService.class.getName());
    public static final String MIME_JSON = "application/json; charset=UTF-8";
    private final Map<String, Object> services = new HashMap<String, Object>();
    private final Map<Object, Map<String, ServiceMethod>> serviceMethods = new HashMap<Object, Map<String, ServiceMethod>>();

    private static Object[] createServices(String serviceClassNames, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ArrayList services = new ArrayList();
        if (serviceClassNames != null) {
            StringTokenizer st = new StringTokenizer(serviceClassNames, ",");
            while (st.hasMoreTokens()) {
                String className = st.nextToken();
                services.add(Class.forName(className, true, classLoader).newInstance());
            }
        }
        return services.toArray();
    }

    public SystemService(String serviceClassNames, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this(SystemService.createServices(serviceClassNames, classLoader));
    }

    public SystemService(Object[] services) {
        this.registerService(new BackendService());
        for (Object service : services) {
            this.registerService(service);
        }
    }

    public void registerService(Object service) {
        this.registerService(service, this.getServiceClassName(service));
    }

    protected String getServiceClassName(Object service) {
        return service.getClass().getSimpleName();
    }

    public void registerService(Object service, String name) {
        if (!this.services.containsKey(name)) {
            this.services.put(name, service);
            this.serviceMethods.put(service, SystemService.buildServiceMethodsFromName(service.getClass()));
        }
    }

    public static Map<String, ServiceMethod> buildServiceMethodsFromName(Class<?> serviceClass) {
        if (Modifier.isAbstract(serviceClass.getModifiers()) || Modifier.isInterface(serviceClass.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s should be a concrete type.", serviceClass.getName()));
        }
        return SystemService.addServiceMethods(serviceClass, serviceClass, new HashMap<String, ServiceMethod>(), new HashMap<Type, Type>());
    }

    private static Map<String, ServiceMethod> addServiceMethods(Class<?> serviceClass, Type serviceType, Map<String, ServiceMethod> methods, Map<Type, Type> resolvedTypes) {
        if (Object.class.equals(serviceClass)) {
            return methods;
        }
        if (serviceType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)serviceType;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeParameters = serviceClass.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type resolved = resolvedTypes.get(actualTypeArguments[i]);
                resolvedTypes.put(typeParameters[i], resolved != null ? resolved : actualTypeArguments[i]);
            }
        }
        for (Method method : serviceClass.getDeclaredMethods()) {
            if (!SystemService.isServiceMethod(method)) continue;
            ServiceMethod serviceMethod = methods.get(method.getName());
            ServiceMethod currentMethod = ServiceMethod.create(method, resolvedTypes);
            if (serviceMethod != null) {
                if (serviceMethod.equals(currentMethod)) continue;
                throw new IllegalArgumentException(String.format("Overloaded methods are not supported. %s has at least one overload: %s and %s", method.getName(), serviceMethod, currentMethod));
            }
            methods.put(method.getName(), currentMethod);
        }
        return SystemService.addServiceMethods(serviceClass.getSuperclass(), serviceClass.getGenericSuperclass(), methods, resolvedTypes);
    }

    static boolean isServiceMethod(Method method) {
        return (method.getModifiers() & 1) != 0 && !method.isBridge();
    }

    public Method resolveService(String serviceName, String methodName) throws ServiceException {
        Object service = this.findService(serviceName);
        if (service == null) {
            throw new ServiceException(404, "service '" + serviceName + "' not found");
        }
        Method method = this.findServiceMethod(service, methodName);
        if (method == null) {
            throw new ServiceException(404, "method '" + serviceName + "." + methodName + "' not found");
        }
        return method;
    }

    public Object findService(String name) {
        Object service = this.services.get(name);
        logger.log(Level.FINE, "{0} => {1}", new Object[]{name, service});
        return service;
    }

    public Method findServiceMethod(Object service, String methodName) {
        return service == null ? null : this.serviceMethods.get(service).get(methodName).getMethod();
    }

    public void invokeServiceMethod(Object service, Method method, ParamReader paramReader, ResultWriter resultWriter) throws IOException {
        Object response;
        Object[] params;
        try {
            params = paramReader.read();
            logger.log(Level.FINE, "params={0} (String)", params == null ? null : params.toString());
        }
        catch (BadRequestException e) {
            resultWriter.writeError(e);
            return;
        }
        try {
            response = method.invoke(service, params);
        }
        catch (IllegalArgumentException e) {
            resultWriter.writeError(new BadRequestException(e));
            return;
        }
        catch (IllegalAccessException e) {
            resultWriter.writeError(new BadRequestException(e));
            return;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            logger.log(Level.INFO, "cause={0}", cause);
            if (cause instanceof ServiceException) {
                resultWriter.writeError((ServiceException)cause);
            } else if (cause instanceof IllegalArgumentException) {
                resultWriter.writeError(new BadRequestException(cause));
            } else if (cause instanceof OAuthRequestException) {
                resultWriter.writeError(new UnauthorizedException(cause));
            } else if (cause.getCause() != null && cause.getCause() instanceof ServiceException) {
                cause = cause.getCause();
                resultWriter.writeError((ServiceException)cause);
            } else {
                logger.log(Level.SEVERE, cause.getMessage(), cause);
                resultWriter.writeError(new InternalServerErrorException(cause));
            }
            return;
        }
        resultWriter.write(response);
    }

    public boolean isJson(String contentType) {
        return MIME_JSON.equals(contentType);
    }

    public static class ServiceMethod {
        private final Method method;
        private final Map<Type, Type> resolvedTypes;

        private ServiceMethod(Method method, Map<Type, Type> resolvedTypes) {
            this.method = method;
            this.resolvedTypes = resolvedTypes;
        }

        private Type resolve(Type type) {
            Type t = this.resolvedTypes.get(type);
            if (t != null) {
                return t;
            }
            if (type instanceof ParameterizedType) {
                t = new ResolvedParameterizedType((ParameterizedType)type);
                this.resolvedTypes.put(type, t);
                return t;
            }
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException(String.format("Wildcard type %s not supported", type));
            }
            return type;
        }

        private Type[] resolve(Type[] types) {
            Type[] resolved = new Type[types.length];
            for (int i = 0; i < types.length; ++i) {
                resolved[i] = this.resolve(types[i]);
            }
            return resolved;
        }

        public Method getMethod() {
            return this.method;
        }

        public Type getReturnType() {
            return this.resolve(this.method.getGenericReturnType());
        }

        public Type[] getParameterTypes() {
            return this.resolve(this.method.getGenericParameterTypes());
        }

        public static ServiceMethod create(Method method, Map<Type, Type> resolvedTypes) {
            Preconditions.checkNotNull(method, "method");
            Preconditions.checkNotNull(resolvedTypes, "resolvedTypes");
            return new ServiceMethod(method, resolvedTypes);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceMethod)) {
                return false;
            }
            ServiceMethod m = (ServiceMethod)o;
            return this.getMethod().getName().equals(m.getMethod().getName()) && Arrays.equals(this.getParameterTypes(), m.getParameterTypes());
        }

        public String toString() {
            return "Method: " + this.getMethod().toString() + ", Resolved Return Type: " + this.getReturnType() + ", Resolved Parameter Types: " + Arrays.toString(this.getParameterTypes());
        }

        public int hashCode() {
            return Objects.hashCode(Arrays.hashCode(this.getParameterTypes()), this.getMethod().getName());
        }

        private final class ResolvedParameterizedType
        implements ParameterizedType {
            private final Type rawType;
            private final Type[] actualTypeArguments;
            private final Type ownerType;

            public ResolvedParameterizedType(ParameterizedType parameterizedType) {
                this.rawType = Preconditions.checkNotNull(parameterizedType.getRawType(), "rawType");
                this.actualTypeArguments = ServiceMethod.this.resolve(Preconditions.checkNotNull(parameterizedType.getActualTypeArguments(), "actualTypeArguments"));
                this.ownerType = parameterizedType.getOwnerType();
            }

            @Override
            public Type getRawType() {
                return this.rawType;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return this.actualTypeArguments;
            }

            @Override
            public Type getOwnerType() {
                return this.ownerType;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder(this.getRawType().toString());
                Type[] resolvedTypeArguments = this.getActualTypeArguments();
                if (resolvedTypeArguments.length != 0) {
                    builder.append('<').append(resolvedTypeArguments[0]);
                    for (int i = 1; i < resolvedTypeArguments.length; ++i) {
                        builder.append(", ").append(resolvedTypeArguments[i]);
                    }
                    builder.append('>');
                }
                return builder.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ParameterizedType)) {
                    return false;
                }
                ParameterizedType that = (ParameterizedType)o;
                Type thatOwner = that.getOwnerType();
                Type thatRawType = that.getRawType();
                return Objects.equal(this.ownerType, thatOwner) && this.rawType.equals(thatRawType) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
            }

            public int hashCode() {
                return Objects.hashCode(Arrays.hashCode(this.actualTypeArguments), this.ownerType, this.rawType);
            }
        }
    }
}

