/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxyServlet
extends HttpServlet {
    public static final String DESTINATION = "destination";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final int BUFFER_SIZE = 4096;
    private String destination;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.destination = config.getInitParameter(DESTINATION);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String value;
        String name;
        String queryString = request.getQueryString();
        String destUrl = this.destination + request.getRequestURI() + (queryString == null ? "" : "?" + queryString);
        HttpURLConnection conn = this.getConnection(destUrl);
        conn.setRequestMethod(request.getMethod());
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = request.getHeader(name);
            conn.setRequestProperty(name, value);
        }
        if (HttpProxyServlet.isOutput(request.getMethod())) {
            conn.setDoOutput(true);
            HttpProxyServlet.copyStream((InputStream)request.getInputStream(), conn.getOutputStream());
        }
        conn.connect();
        response.setStatus(conn.getResponseCode());
        int i = 0;
        while (true) {
            name = conn.getHeaderFieldKey(i);
            value = conn.getHeaderField(i);
            if (name == null && value == null) break;
            if (name != null && !CONTENT_LENGTH.equalsIgnoreCase(name)) {
                response.setHeader(name, value);
            }
            ++i;
        }
        int length = HttpProxyServlet.copyStream(conn.getInputStream(), (OutputStream)response.getOutputStream());
        if (length > 0) {
            response.setContentLength(length);
        }
    }

    protected HttpURLConnection getConnection(String destUrl) throws IOException, MalformedURLException {
        return (HttpURLConnection)new URL(destUrl).openConnection();
    }

    private static boolean isOutput(String method) {
        return "POST".equals(method) || "PUT".equals(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copyStream(InputStream from, OutputStream to) throws IOException {
        try {
            byte[] bbuf = new byte[4096];
            int length = 0;
            int fragment = from.read(bbuf);
            while (fragment >= 0) {
                to.write(bbuf, 0, fragment);
                length += fragment;
                fragment = from.read(bbuf);
            }
            int n = length;
            return n;
        }
        finally {
            to.close();
            from.close();
        }
    }
}

