/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.HTMLEntity;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public final class z_T4JInternalParseUtil {
    private static ThreadLocal<Map<String, SimpleDateFormat>> formatMap = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };

    private z_T4JInternalParseUtil() {
        throw new AssertionError();
    }

    static String getUnescapedString(String str, JSONObject json) {
        return HTMLEntity.unescape(z_T4JInternalParseUtil.getRawString(str, json));
    }

    public static String getRawString(String name, JSONObject json) {
        try {
            if (json.isNull(name)) {
                return null;
            }
            return json.getString(name);
        }
        catch (JSONException jsone) {
            return null;
        }
    }

    static String getURLDecodedString(String name, JSONObject json) {
        String returnValue = z_T4JInternalParseUtil.getRawString(name, json);
        if (returnValue != null) {
            try {
                returnValue = URLDecoder.decode(returnValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static Date parseTrendsDate(String asOfStr) throws TwitterException {
        Date parsed;
        switch (asOfStr.length()) {
            case 10: {
                parsed = new Date(Long.parseLong(asOfStr) * 1000L);
                break;
            }
            case 20: {
                parsed = z_T4JInternalParseUtil.getDate(asOfStr, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                break;
            }
            default: {
                parsed = z_T4JInternalParseUtil.getDate(asOfStr, "EEE, d MMM yyyy HH:mm:ss z");
            }
        }
        return parsed;
    }

    public static Date getDate(String name, JSONObject json) throws TwitterException {
        return z_T4JInternalParseUtil.getDate(name, json, "EEE MMM d HH:mm:ss z yyyy");
    }

    public static Date getDate(String name, JSONObject json, String format) throws TwitterException {
        String dateStr = z_T4JInternalParseUtil.getUnescapedString(name, json);
        if ("null".equals(dateStr) || null == dateStr) {
            return null;
        }
        return z_T4JInternalParseUtil.getDate(dateStr, format);
    }

    public static Date getDate(String name, String format) throws TwitterException {
        SimpleDateFormat sdf = formatMap.get().get(format);
        if (null == sdf) {
            sdf = new SimpleDateFormat(format, Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            formatMap.get().put(format, sdf);
        }
        try {
            return sdf.parse(name);
        }
        catch (ParseException pe) {
            throw new TwitterException("Unexpected date format(" + name + ") returned from twitter.com", pe);
        }
    }

    public static int getInt(String name, JSONObject json) {
        return z_T4JInternalParseUtil.getInt(z_T4JInternalParseUtil.getRawString(name, json));
    }

    public static int getInt(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static long getLong(String name, JSONObject json) {
        return z_T4JInternalParseUtil.getLong(z_T4JInternalParseUtil.getRawString(name, json));
    }

    public static long getLong(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1L;
        }
        if (str.endsWith("+")) {
            str = str.substring(0, str.length() - 1);
            return Long.valueOf(str) + 1L;
        }
        return Long.valueOf(str);
    }

    public static double getDouble(String name, JSONObject json) {
        String str2 = z_T4JInternalParseUtil.getRawString(name, json);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return -1.0;
        }
        return Double.valueOf(str2);
    }

    public static boolean getBoolean(String name, JSONObject json) {
        String str = z_T4JInternalParseUtil.getRawString(name, json);
        if (null == str || "null".equals(str)) {
            return false;
        }
        return Boolean.valueOf(str);
    }

    public static int toAccessLevel(HttpResponse res) {
        int accessLevel;
        if (null == res) {
            return -1;
        }
        String xAccessLevel = res.getResponseHeader("X-Access-Level");
        if (null == xAccessLevel) {
            accessLevel = 0;
        } else {
            switch (xAccessLevel.length()) {
                case 4: {
                    accessLevel = 1;
                    break;
                }
                case 10: {
                    accessLevel = 2;
                    break;
                }
                case 25: {
                    accessLevel = 3;
                    break;
                }
                case 26: {
                    accessLevel = 3;
                    break;
                }
                default: {
                    accessLevel = 0;
                }
            }
        }
        return accessLevel;
    }
}

