/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.internal.SqlClient;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractSqlClient
implements SqlClient {
    private static final long PROTOCOL_VERSION = 1L;
    private final AtomicLong idempotentRequestId = new AtomicLong();
    private final String instance;

    protected AbstractSqlClient(String instance) {
        if (instance == null || instance.isEmpty()) {
            throw new IllegalArgumentException("invalid instance: (" + instance + ").");
        }
        this.instance = Util.makeSafe(instance);
    }

    protected String getInstance() {
        return this.instance;
    }

    protected ExecRequest createExecRequest(SqlRpcOptions options, ByteString connectionId, String sql, List<Client.BindVariableProto> bindParameters) throws SQLException {
        ExecRequest.Builder request = this.createExecRequestBuilder(options, connectionId, sql);
        for (Client.BindVariableProto b : bindParameters) {
            request.addBindVariable(b);
        }
        return request.build();
    }

    protected ExecRequest createBatchExecRequest(SqlRpcOptions options, ByteString connectionId, String sql, List<List<Client.BindVariableProto>> batchBindParameters) throws SQLException {
        ExecRequest.Builder request = this.createExecRequestBuilder(options, connectionId, sql);
        Client.BatchProto.Builder batch = Client.BatchProto.newBuilder();
        for (List<Client.BindVariableProto> bindParameters : batchBindParameters) {
            Client.BatchBindVariableProto.Builder bbv = Client.BatchBindVariableProto.newBuilder();
            for (Client.BindVariableProto b : bindParameters) {
                bbv.addBindVariable(b);
            }
            batch.addBatchBindVariable(bbv);
        }
        request.setBatch(batch);
        return request.build();
    }

    protected ExecRequest createBatchExecRequest(SqlRpcOptions options, ByteString connectionId, List<String> batchSql) throws SQLException {
        return this.createExecRequestBuilder(options, connectionId, null).setBatch(Client.BatchProto.newBuilder().addAllStatement(batchSql)).build();
    }

    private ExecRequest.Builder createExecRequestBuilder(SqlRpcOptions options, ByteString connectionId, String sql) {
        ExecRequest.Builder request = ExecRequest.newBuilder().setStatementType(options.getStatementType()).setInstance(this.getInstance()).setConnectionId(connectionId).setRequestId(this.idempotentRequestId.incrementAndGet());
        if (sql != null) {
            request.setStatement(sql);
        }
        request.setOptions(this.createExecOptions(options));
        return request;
    }

    private Client.ExecOptions createExecOptions(SqlRpcOptions options) {
        Client.ExecOptions.Builder optionsBuilder = Client.ExecOptions.newBuilder();
        if (options.getIncludeExportedKeys()) {
            optionsBuilder.setIncludeGeneratedKeys(true);
        }
        if (options.getGeneratedColumnIndices() != null) {
            for (int index : options.getGeneratedColumnIndices()) {
                optionsBuilder.addGeneratedColumnIndices(index);
            }
        }
        if (options.getGeneratedColumnNames() != null) {
            optionsBuilder.addAllGeneratedColumnNames(Arrays.asList(options.getGeneratedColumnNames()));
        }
        if (options.getFetchSize() != 0) {
            optionsBuilder.setFetchSize(options.getFetchSize());
        }
        if (options.getMaxRows() != 0) {
            optionsBuilder.setMaxRows(options.getMaxRows());
        }
        if (options.isPoolable()) {
            optionsBuilder.setPoolable(true);
        }
        if (options.getFetchDirection() != 1000) {
            optionsBuilder.setFetchDirection(Client.FetchDirection.valueOf(options.getFetchDirection()));
        }
        if (options.getMaxFieldSize() != 0) {
            optionsBuilder.setMaxFieldSize(options.getMaxFieldSize());
        }
        if (options.getCursorName() != null) {
            optionsBuilder.setCursorName(options.getCursorName());
        }
        if (options.getEscapeProcessing()) {
            optionsBuilder.setEscapeProcessing(true);
        }
        optionsBuilder.setType(Client.ResultSetType.valueOf(options.getResultSetType()));
        optionsBuilder.setConcurrency(Client.ResultSetConcurrency.valueOf(options.getResultSetConcurrency()));
        optionsBuilder.setHoldability(Client.ResultSetHoldability.valueOf(options.getResultSetHoldability()));
        return optionsBuilder.build();
    }

    protected ExecRequest createExecNextRequest(SqlRpcOptions options, ByteString connectionId, long statementId) {
        ExecRequest.Builder request = ExecRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setStatementId(statementId);
        request.setOptions(this.createExecOptions(options));
        return request.build();
    }

    protected ExecOpRequest createExecOpRequest(ByteString connectionId, Client.OpProto op) {
        ExecOpRequest.Builder request = ExecOpRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setOp(op).setRequestId(this.idempotentRequestId.incrementAndGet());
        return request.build();
    }

    protected OpenConnectionRequest createConnectRequest(Url url) {
        OpenConnectionRequest.Builder request = OpenConnectionRequest.newBuilder();
        for (Map.Entry<String, String> e : url.getProperties().entrySet()) {
            request.addProperty(Client.Property.newBuilder().setKey(e.getKey()).setValue(e.getValue()));
        }
        request.setInstance(this.getInstance());
        request.setProtocolVersion(1L);
        request.setClientType(Client.ClientType.CLIENT_TYPE_JAVA_JDBC);
        return request.build();
    }

    protected CloseConnectionRequest createReleaseRequest(ByteString connectionId) {
        return CloseConnectionRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).build();
    }

    protected MetadataRequest createMetadataRequest(ByteString connectionId, Client.MetadataType metadataType, List<Client.BindVariableProto> bindParameters) throws SQLException {
        MetadataRequest.Builder request = MetadataRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setMetadata(metadataType).setRequestId(this.idempotentRequestId.incrementAndGet());
        for (Client.BindVariableProto b : bindParameters) {
            request.addBindVariable(b);
        }
        return request.build();
    }
}

