/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.field;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.IllegalFieldValueException;
import com.google.appengine.repackaged.org.joda.time.field.DelegatedDateTimeField;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;

public final class SkipDateTimeField
extends DelegatedDateTimeField {
    private static final long serialVersionUID = -8869148464118507846L;
    private final Chronology iChronology;
    private final int iSkip;
    private transient int iMinValue;

    public SkipDateTimeField(Chronology chronology, DateTimeField field) {
        this(chronology, field, 0);
    }

    public SkipDateTimeField(Chronology chronology, DateTimeField field, int skip) {
        super(field);
        this.iChronology = chronology;
        int min = super.getMinimumValue();
        this.iMinValue = min < skip ? min - 1 : (min == skip ? skip + 1 : min);
        this.iSkip = skip;
    }

    @Override
    public int get(long millis) {
        int value = super.get(millis);
        if (value <= this.iSkip) {
            --value;
        }
        return value;
    }

    @Override
    public long set(long millis, int value) {
        FieldUtils.verifyValueBounds(this, value, this.iMinValue, this.getMaximumValue());
        if (value <= this.iSkip) {
            if (value == this.iSkip) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)value, null, null);
            }
            ++value;
        }
        return super.set(millis, value);
    }

    @Override
    public int getMinimumValue() {
        return this.iMinValue;
    }

    private Object readResolve() {
        return this.getType().getField(this.iChronology);
    }
}

