/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.LocalDate;
import com.google.appengine.repackaged.org.joda.time.Period;
import com.google.appengine.repackaged.org.joda.time.PeriodType;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadableInterval;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.base.BaseSingleFieldPeriod;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.ISOPeriodFormat;
import com.google.appengine.repackaged.org.joda.time.format.PeriodFormatter;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Months
extends BaseSingleFieldPeriod {
    public static final Months ZERO = new Months(0);
    public static final Months ONE = new Months(1);
    public static final Months TWO = new Months(2);
    public static final Months THREE = new Months(3);
    public static final Months FOUR = new Months(4);
    public static final Months FIVE = new Months(5);
    public static final Months SIX = new Months(6);
    public static final Months SEVEN = new Months(7);
    public static final Months EIGHT = new Months(8);
    public static final Months NINE = new Months(9);
    public static final Months TEN = new Months(10);
    public static final Months ELEVEN = new Months(11);
    public static final Months TWELVE = new Months(12);
    public static final Months MAX_VALUE = new Months(Integer.MAX_VALUE);
    public static final Months MIN_VALUE = new Months(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.months());
    private static final long serialVersionUID = 87525275727380867L;

    public static Months months(int months) {
        switch (months) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 8: {
                return EIGHT;
            }
            case 9: {
                return NINE;
            }
            case 10: {
                return TEN;
            }
            case 11: {
                return ELEVEN;
            }
            case 12: {
                return TWELVE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Months(months);
    }

    public static Months monthsBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.months());
        return Months.months(amount);
    }

    public static Months monthsBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalDate && end instanceof LocalDate) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int months = chrono.months().getDifference(((LocalDate)end).getLocalMillis(), ((LocalDate)start).getLocalMillis());
            return Months.months(months);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Months.months(amount);
    }

    public static Months monthsIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.months());
        return Months.months(amount);
    }

    @FromString
    public static Months parseMonths(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Months.months(p.getMonths());
    }

    private Months(int months) {
        super(months);
    }

    private Object readResolve() {
        return Months.months(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.months();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.months();
    }

    public int getMonths() {
        return this.getValue();
    }

    public Months plus(int months) {
        if (months == 0) {
            return this;
        }
        return Months.months(FieldUtils.safeAdd(this.getValue(), months));
    }

    public Months plus(Months months) {
        if (months == null) {
            return this;
        }
        return this.plus(months.getValue());
    }

    public Months minus(int months) {
        return this.plus(FieldUtils.safeNegate(months));
    }

    public Months minus(Months months) {
        if (months == null) {
            return this;
        }
        return this.minus(months.getValue());
    }

    public Months multipliedBy(int scalar) {
        return Months.months(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Months dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Months.months(this.getValue() / divisor);
    }

    public Months negated() {
        return Months.months(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Months other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Months other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "M";
    }
}

