/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.hash.AbstractStreamingHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashCodes;
import com.google.appengine.repackaged.com.google.common.hash.Hasher;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@GoogleInternal
final class GoogleLegacy64HashFunction
extends AbstractStreamingHashFunction {
    private final long constant;
    private final long seed;

    GoogleLegacy64HashFunction(long constant, long seed) {
        this.constant = constant;
        this.seed = seed;
    }

    @Override
    public int bits() {
        return 64;
    }

    @Override
    public Hasher newHasher() {
        return new GoogleLegacy64Hasher(new GoogleLegacy64Mixer(this.constant, this.constant, this.seed));
    }

    @Override
    public HashCode hashLong(long input) {
        long a = this.constant + (input & 0xFFL) + (input & 0xFF00L) + (input & 0xFF0000L) + (input & 0xFF000000L) + (input & 0xFF00000000L) + (input & 0xFF0000000000L) + (input & 0xFF000000000000L) + (input & 0xFF00000000000000L);
        return HashCodes.fromLong(GoogleLegacy64HashFunction.mix64(a, this.constant, this.seed + 8L));
    }

    @Override
    public HashCode hashInt(int input) {
        long a = this.constant + ((long)input & 0xFFL) + ((long)input & 0xFF00L) + ((long)input & 0xFF0000L) + ((long)input & 0xFF000000L);
        return HashCodes.fromLong(GoogleLegacy64HashFunction.mix64(a, this.constant, this.seed + 4L));
    }

    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        return this.hashBytes(((Object)input).toString().getBytes(charset));
    }

    @Override
    public HashCode hashBytes(byte[] input) {
        return this.hashBytes(input, 0, input.length);
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        long a = this.constant;
        long b = this.constant;
        long c = this.seed;
        int keylen = len;
        while (keylen >= 24) {
            a += GoogleLegacy64HashFunction.word64At(input, off);
            a -= (b += GoogleLegacy64HashFunction.word64At(input, off + 8));
            a -= (c += GoogleLegacy64HashFunction.word64At(input, off + 16));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            keylen -= 24;
            off += 24;
        }
        c += (long)len;
        switch (keylen) {
            case 23: {
                c += (long)input[off + 22] << 56;
            }
            case 22: {
                c += ((long)input[off + 21] & 0xFFL) << 48;
            }
            case 21: {
                c += ((long)input[off + 20] & 0xFFL) << 40;
            }
            case 20: {
                c += ((long)input[off + 19] & 0xFFL) << 32;
            }
            case 19: {
                c += ((long)input[off + 18] & 0xFFL) << 24;
            }
            case 18: {
                c += ((long)input[off + 17] & 0xFFL) << 16;
            }
            case 17: {
                c += ((long)input[off + 16] & 0xFFL) << 8;
            }
            case 16: {
                b += GoogleLegacy64HashFunction.word64At(input, off + 8);
                a += GoogleLegacy64HashFunction.word64At(input, off);
                break;
            }
            case 15: {
                b += ((long)input[off + 14] & 0xFFL) << 48;
            }
            case 14: {
                b += ((long)input[off + 13] & 0xFFL) << 40;
            }
            case 13: {
                b += ((long)input[off + 12] & 0xFFL) << 32;
            }
            case 12: {
                b += ((long)input[off + 11] & 0xFFL) << 24;
            }
            case 11: {
                b += ((long)input[off + 10] & 0xFFL) << 16;
            }
            case 10: {
                b += ((long)input[off + 9] & 0xFFL) << 8;
            }
            case 9: {
                b += (long)input[off + 8] & 0xFFL;
            }
            case 8: {
                a += GoogleLegacy64HashFunction.word64At(input, off);
                break;
            }
            case 7: {
                a += ((long)input[off + 6] & 0xFFL) << 48;
            }
            case 6: {
                a += ((long)input[off + 5] & 0xFFL) << 40;
            }
            case 5: {
                a += ((long)input[off + 4] & 0xFFL) << 32;
            }
            case 4: {
                a += ((long)input[off + 3] & 0xFFL) << 24;
            }
            case 3: {
                a += ((long)input[off + 2] & 0xFFL) << 16;
            }
            case 2: {
                a += ((long)input[off + 1] & 0xFFL) << 8;
            }
            case 1: {
                a += (long)input[off + 0] & 0xFFL;
            }
        }
        return HashCodes.fromLong(GoogleLegacy64HashFunction.mix64(a, b, c));
    }

    static long mix64(long a, long b, long c) {
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }

    private static long word64At(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) + (((long)bytes[offset + 1] & 0xFFL) << 8) + (((long)bytes[offset + 2] & 0xFFL) << 16) + (((long)bytes[offset + 3] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 6] & 0xFFL) << 48) + (((long)bytes[offset + 7] & 0xFFL) << 56);
    }

    private static final class GoogleLegacy64Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        private static final int CHUNK_SIZE = 24;
        private final GoogleLegacy64Mixer mixer;
        private int length = 0;

        private GoogleLegacy64Hasher(GoogleLegacy64Mixer mixer) {
            super(24);
            this.mixer = mixer;
        }

        @Override
        protected void process(ByteBuffer buf) {
            this.length += 24;
            this.mixer.a += buf.getLong();
            this.mixer.b += buf.getLong();
            this.mixer.c += buf.getLong();
            this.mixer.mix();
        }

        @Override
        protected void processRemaining(ByteBuffer buf) {
            this.length += buf.remaining();
            switch (buf.remaining()) {
                case 23: {
                    this.mixer.c += (long)buf.get(22) << 56;
                }
                case 22: {
                    this.mixer.c += ((long)buf.get(21) & 0xFFL) << 48;
                }
                case 21: {
                    this.mixer.c += ((long)buf.get(20) & 0xFFL) << 40;
                }
                case 20: {
                    this.mixer.c += ((long)buf.get(19) & 0xFFL) << 32;
                }
                case 19: {
                    this.mixer.c += ((long)buf.get(18) & 0xFFL) << 24;
                }
                case 18: {
                    this.mixer.c += ((long)buf.get(17) & 0xFFL) << 16;
                }
                case 17: {
                    this.mixer.c += ((long)buf.get(16) & 0xFFL) << 8;
                }
                case 16: {
                    this.mixer.a += buf.getLong();
                    this.mixer.b += buf.getLong();
                    break;
                }
                case 15: {
                    this.mixer.b += ((long)buf.get(14) & 0xFFL) << 48;
                }
                case 14: {
                    this.mixer.b += ((long)buf.get(13) & 0xFFL) << 40;
                }
                case 13: {
                    this.mixer.b += ((long)buf.get(12) & 0xFFL) << 32;
                }
                case 12: {
                    this.mixer.b += ((long)buf.get(11) & 0xFFL) << 24;
                }
                case 11: {
                    this.mixer.b += ((long)buf.get(10) & 0xFFL) << 16;
                }
                case 10: {
                    this.mixer.b += ((long)buf.get(9) & 0xFFL) << 8;
                }
                case 9: {
                    this.mixer.b += (long)buf.get(8) & 0xFFL;
                }
                case 8: {
                    this.mixer.a += buf.getLong();
                    break;
                }
                case 7: {
                    this.mixer.a += ((long)buf.get(6) & 0xFFL) << 48;
                }
                case 6: {
                    this.mixer.a += ((long)buf.get(5) & 0xFFL) << 40;
                }
                case 5: {
                    this.mixer.a += ((long)buf.get(4) & 0xFFL) << 32;
                }
                case 4: {
                    this.mixer.a += ((long)buf.get(3) & 0xFFL) << 24;
                }
                case 3: {
                    this.mixer.a += ((long)buf.get(2) & 0xFFL) << 16;
                }
                case 2: {
                    this.mixer.a += ((long)buf.get(1) & 0xFFL) << 8;
                }
                case 1: {
                    this.mixer.a += (long)buf.get(0) & 0xFFL;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
        }

        @Override
        public HashCode makeHash() {
            this.mixer.c += this.length;
            return this.mixer.makeHash();
        }
    }

    static final class GoogleLegacy64Mixer {
        private long a;
        private long b;
        private long c;

        GoogleLegacy64Mixer(long a, long b, long c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        HashCode makeHash() {
            return HashCodes.fromLong(this.mix());
        }

        private long mix() {
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 43;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 9;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 8;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 38;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 23;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 5;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 35;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 49;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 11;
            this.a -= this.b;
            this.a -= this.c;
            this.a ^= this.c >>> 12;
            this.b -= this.c;
            this.b -= this.a;
            this.b ^= this.a << 18;
            this.c -= this.a;
            this.c -= this.b;
            this.c ^= this.b >>> 22;
            return this.c;
        }
    }
}

