/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.http.json;

import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.appengine.repackaged.com.google.api.client.http.HttpMethod;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.UriTemplate;
import com.google.appengine.repackaged.com.google.api.client.http.json.JsonHttpClient;
import com.google.appengine.repackaged.com.google.api.client.util.GenericData;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JsonHttpRequest
extends GenericData {
    private final JsonHttpClient client;
    private final HttpMethod method;
    private final String uriTemplate;
    private final Object content;
    private HttpHeaders requestHeaders = new HttpHeaders();
    private HttpHeaders lastResponseHeaders;
    private boolean enableGZipContent = true;

    public JsonHttpRequest(JsonHttpClient client, HttpMethod method, String uriTemplate, Object content) {
        this.client = Preconditions.checkNotNull(client);
        this.method = Preconditions.checkNotNull(method);
        this.uriTemplate = Preconditions.checkNotNull(uriTemplate);
        this.content = content;
    }

    public JsonHttpRequest setEnableGZipContent(boolean enableGZipContent) {
        this.enableGZipContent = enableGZipContent;
        return this;
    }

    public final boolean getEnableGZipContent() {
        return this.enableGZipContent;
    }

    public final HttpMethod getMethod() {
        return this.method;
    }

    public final String getUriTemplate() {
        return this.uriTemplate;
    }

    public final Object getJsonContent() {
        return this.content;
    }

    public final JsonHttpClient getClient() {
        return this.client;
    }

    public JsonHttpRequest setRequestHeaders(HttpHeaders headers) {
        this.requestHeaders = headers;
        return this;
    }

    public final HttpHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public final HttpHeaders getLastResponseHeaders() {
        return this.lastResponseHeaders;
    }

    public final GenericUrl buildHttpRequestUrl() {
        String baseUrl = this.getClient().isBaseUrlUsed() ? this.getClient().getBaseUrl() : this.getClient().getRootUrl() + this.getClient().getServicePath();
        return new GenericUrl(UriTemplate.expand(baseUrl, this.uriTemplate, this, true));
    }

    public HttpRequest buildHttpRequest() throws IOException {
        HttpRequest request = this.client.buildHttpRequest(this.method, this.buildHttpRequestUrl(), this.content);
        request.getHeaders().putAll(this.getRequestHeaders());
        return request;
    }

    public HttpResponse executeUnparsed() throws IOException {
        HttpRequest request = this.buildHttpRequest();
        request.setEnableGZipContent(this.enableGZipContent);
        HttpResponse response = this.client.executeUnparsed(request);
        this.lastResponseHeaders = response.getHeaders();
        return response;
    }

    public InputStream executeAsInputStream() throws IOException {
        HttpResponse response = this.executeUnparsed();
        return response.getContent();
    }

    public void download(OutputStream outputStream) throws IOException {
        HttpResponse response = this.executeUnparsed();
        response.download(outputStream);
    }
}

