/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.http.javanet;

import com.google.appengine.repackaged.com.google.api.client.http.HttpContent;
import com.google.appengine.repackaged.com.google.api.client.http.LowLevelHttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.LowLevelHttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpResponse;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;
    private HttpContent content;

    NetHttpRequest(String requestMethod, String url) throws IOException {
        this(requestMethod, (HttpURLConnection)new URL(url).openConnection());
    }

    NetHttpRequest(String requestMethod, HttpURLConnection connection) throws ProtocolException {
        this.connection = connection;
        connection.setRequestMethod(requestMethod);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
    }

    @Override
    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connection.setReadTimeout(readTimeout);
        this.connection.setConnectTimeout(connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LowLevelHttpResponse execute() throws IOException {
        HttpURLConnection connection = this.connection;
        if (this.content != null) {
            String requestMethod;
            long contentLength;
            String contentEncoding;
            String contentType = this.content.getType();
            if (contentType != null) {
                this.addHeader("Content-Type", contentType);
            }
            if ((contentEncoding = this.content.getEncoding()) != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = this.content.getLength()) >= 0L) {
                this.addHeader("Content-Length", Long.toString(contentLength));
            }
            if ("POST".equals(requestMethod = connection.getRequestMethod()) || "PUT".equals(requestMethod)) {
                connection.setDoOutput(true);
                if (contentLength >= 0L && contentLength <= Integer.MAX_VALUE) {
                    connection.setFixedLengthStreamingMode((int)contentLength);
                } else {
                    connection.setChunkedStreamingMode(0);
                }
                OutputStream out = connection.getOutputStream();
                try {
                    this.content.writeTo(out);
                }
                finally {
                    out.close();
                }
            } else {
                Preconditions.checkArgument(contentLength == 0L, "%s with non-zero content length is not supported", requestMethod);
            }
        }
        boolean successfulConnection = false;
        try {
            connection.connect();
            NetHttpResponse response = new NetHttpResponse(connection);
            successfulConnection = true;
            NetHttpResponse netHttpResponse = response;
            return netHttpResponse;
        }
        finally {
            if (!successfulConnection) {
                connection.disconnect();
            }
        }
    }

    @Override
    public void setContent(HttpContent content) {
        this.content = content;
    }
}

