/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.http;

import com.google.appengine.repackaged.com.google.api.client.http.HttpContent;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractInputStreamContent
implements HttpContent {
    private String type;
    private String encoding;
    private boolean closeInputStream = true;

    public AbstractInputStreamContent(String type) {
        this.setType(type);
    }

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public void writeTo(OutputStream out) throws IOException {
        AbstractInputStreamContent.copy(this.getInputStream(), out, this.closeInputStream);
        out.flush();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public final boolean getCloseInputStream() {
        return this.closeInputStream;
    }

    public AbstractInputStreamContent setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public AbstractInputStreamContent setType(String type) {
        this.type = type;
        return this;
    }

    public AbstractInputStreamContent setCloseInputStream(boolean closeInputStream) {
        this.closeInputStream = closeInputStream;
        return this;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        AbstractInputStreamContent.copy(inputStream, outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream, boolean closeInputStream) throws IOException {
        try {
            ByteStreams.copy(inputStream, outputStream);
        }
        finally {
            if (closeInputStream) {
                inputStream.close();
            }
        }
    }
}

