/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.appengine.repackaged.com.google.api.client.util.Key;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

public class GoogleAuthorizationCodeRequestUrl
extends AuthorizationCodeRequestUrl {
    @Key(value="approval_prompt")
    private String approvalPrompt;
    @Key(value="access_type")
    private String accessType;

    public GoogleAuthorizationCodeRequestUrl(String clientId, String redirectUri, Iterable<String> scopes) {
        super("https://accounts.google.com/o/oauth2/auth", clientId);
        this.setRedirectUri(redirectUri);
        this.setScopes((Iterable)scopes);
    }

    public GoogleAuthorizationCodeRequestUrl(GoogleClientSecrets clientSecrets, String redirectUri, Iterable<String> scopes) {
        this(clientSecrets.getDetails().getClientId(), redirectUri, scopes);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public GoogleAuthorizationCodeRequestUrl setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
        return this;
    }

    public final String getAccessType() {
        return this.accessType;
    }

    public GoogleAuthorizationCodeRequestUrl setAccessType(String accessType) {
        this.accessType = accessType;
        return this;
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setResponseTypes(String ... responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes(responseTypes);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setResponseTypes(Iterable<String> responseTypes) {
        return (GoogleAuthorizationCodeRequestUrl)super.setResponseTypes((Iterable)responseTypes);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setRedirectUri(String redirectUri) {
        Preconditions.checkNotNull(redirectUri);
        return (GoogleAuthorizationCodeRequestUrl)super.setRedirectUri(redirectUri);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setScopes(String ... scopes) {
        Preconditions.checkArgument(scopes.length != 0);
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes(scopes);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setScopes(Iterable<String> scopes) {
        Preconditions.checkArgument(scopes.iterator().hasNext());
        return (GoogleAuthorizationCodeRequestUrl)super.setScopes((Iterable)scopes);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setClientId(String clientId) {
        return (GoogleAuthorizationCodeRequestUrl)super.setClientId(clientId);
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl setState(String state) {
        return (GoogleAuthorizationCodeRequestUrl)super.setState(state);
    }
}

