/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.BearerToken;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialStore;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.util.Clock;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Collections;

public class GoogleAuthorizationCodeFlow
extends AuthorizationCodeFlow {
    private final String approvalPrompt;
    private final String accessType;

    protected GoogleAuthorizationCodeFlow(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl, CredentialStore credentialStore, HttpRequestInitializer requestInitializer, String scopes, String accessType, String approvalPrompt) {
        super(method, transport, jsonFactory, tokenServerUrl, clientAuthentication, clientId, authorizationServerEncodedUrl, credentialStore, requestInitializer, scopes);
        this.accessType = accessType;
        this.approvalPrompt = approvalPrompt;
    }

    @Override
    public GoogleAuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        return new GoogleAuthorizationCodeTokenRequest(this.getTransport(), this.getJsonFactory(), "", "", authorizationCode, "").setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).setScopes(this.getScopes());
    }

    @Override
    public GoogleAuthorizationCodeRequestUrl newAuthorizationUrl() {
        return new GoogleAuthorizationCodeRequestUrl(this.getClientId(), "", Collections.singleton(this.getScopes())).setAccessType(this.accessType).setApprovalPrompt(this.approvalPrompt);
    }

    public final String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public final String getAccessType() {
        return this.accessType;
    }

    public static class Builder
    extends AuthorizationCodeFlow.Builder {
        private String approvalPrompt;
        private String accessType;

        public Builder(HttpTransport transport, JsonFactory jsonFactory, String clientId, String clientSecret, Iterable<String> scopes) {
            super(BearerToken.authorizationHeaderAccessMethod(), transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), new ClientParametersAuthentication(clientId, clientSecret), clientId, "https://accounts.google.com/o/oauth2/auth");
            this.setScopes((Iterable)Preconditions.checkNotNull(scopes));
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, GoogleClientSecrets clientSecrets, Iterable<String> scopes) {
            super(BearerToken.authorizationHeaderAccessMethod(), transport, jsonFactory, new GenericUrl("https://accounts.google.com/o/oauth2/token"), new ClientParametersAuthentication(clientSecrets.getDetails().getClientId(), clientSecrets.getDetails().getClientSecret()), clientSecrets.getDetails().getClientId(), "https://accounts.google.com/o/oauth2/auth");
            this.setScopes((Iterable)Preconditions.checkNotNull(scopes));
        }

        @Override
        public GoogleAuthorizationCodeFlow build() {
            return new GoogleAuthorizationCodeFlow(this.getMethod(), this.getTransport(), this.getJsonFactory(), this.getTokenServerUrl(), this.getClientAuthentication(), this.getClientId(), this.getAuthorizationServerEncodedUrl(), this.getCredentialStore(), this.getRequestInitializer(), this.getScopes(), this.accessType, this.approvalPrompt);
        }

        @Override
        public Builder setCredentialStore(CredentialStore credentialStore) {
            return (Builder)super.setCredentialStore(credentialStore);
        }

        @Override
        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        @Override
        public Builder setScopes(Iterable<String> scopes) {
            return (Builder)super.setScopes(scopes);
        }

        @Override
        public Builder setScopes(String ... scopes) {
            return (Builder)super.setScopes(scopes);
        }

        @Override
        public Builder setMethod(Credential.AccessMethod method) {
            return (Builder)super.setMethod(method);
        }

        @Override
        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport(transport);
        }

        @Override
        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory(jsonFactory);
        }

        @Override
        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            return (Builder)super.setTokenServerUrl(tokenServerUrl);
        }

        @Override
        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            return (Builder)super.setClientAuthentication(clientAuthentication);
        }

        @Override
        public Builder setClientId(String clientId) {
            return (Builder)super.setClientId(clientId);
        }

        @Override
        public Builder setAuthorizationServerEncodedUrl(String authorizationServerEncodedUrl) {
            return (Builder)super.setAuthorizationServerEncodedUrl(authorizationServerEncodedUrl);
        }

        @Override
        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        public Builder setApprovalPrompt(String approvalPrompt) {
            this.approvalPrompt = approvalPrompt;
            return this;
        }

        public final String getApprovalPrompt() {
            return this.approvalPrompt;
        }

        public Builder setAccessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }
    }
}

