/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialStore;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.MemoryPersistedCredential;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MemoryCredentialStore
implements CredentialStore {
    private final Lock lock = new ReentrantLock();
    private final Map<String, MemoryPersistedCredential> store = new HashMap<String, MemoryPersistedCredential>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String userId, Credential credential) {
        this.lock.lock();
        try {
            MemoryPersistedCredential item = this.store.get(userId);
            if (item == null) {
                item = new MemoryPersistedCredential();
                this.store.put(userId, item);
            }
            item.store(credential);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String userId, Credential credential) {
        this.lock.lock();
        try {
            this.store.remove(userId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(String userId, Credential credential) {
        this.lock.lock();
        try {
            MemoryPersistedCredential item = this.store.get(userId);
            if (item != null) {
                item.load(credential);
            }
            boolean bl = item != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

