/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialStore;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;

public final class CredentialStoreRefreshListener
implements CredentialRefreshListener {
    private final CredentialStore credentialStore;
    private final String userId;

    public CredentialStoreRefreshListener(String userId, CredentialStore credentialStore) {
        this.userId = Preconditions.checkNotNull(userId);
        this.credentialStore = Preconditions.checkNotNull(credentialStore);
    }

    @Override
    public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
        this.makePersistent(credential);
    }

    @Override
    public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
        this.makePersistent(credential);
    }

    public CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public void makePersistent(Credential credential) throws IOException {
        this.credentialStore.store(this.userId, credential);
    }
}

