/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialStore;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialStoreRefreshListener;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.util.Clock;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public class AuthorizationCodeFlow {
    private final Credential.AccessMethod method;
    private final HttpTransport transport;
    private final JsonFactory jsonFactory;
    private final String tokenServerEncodedUrl;
    private final HttpExecuteInterceptor clientAuthentication;
    private final String clientId;
    private final String authorizationServerEncodedUrl;
    private final CredentialStore credentialStore;
    private final HttpRequestInitializer requestInitializer;
    private final Clock clock;
    private String scopes;

    protected AuthorizationCodeFlow(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl, CredentialStore credentialStore, HttpRequestInitializer requestInitializer, String scopes) {
        this(method, transport, jsonFactory, tokenServerUrl, clientAuthentication, clientId, authorizationServerEncodedUrl, credentialStore, requestInitializer, scopes, Clock.SYSTEM);
    }

    protected AuthorizationCodeFlow(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl, CredentialStore credentialStore, HttpRequestInitializer requestInitializer, String scopes, Clock clock) {
        this.method = Preconditions.checkNotNull(method);
        this.transport = Preconditions.checkNotNull(transport);
        this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        this.tokenServerEncodedUrl = Preconditions.checkNotNull(tokenServerUrl).build();
        this.clientAuthentication = clientAuthentication;
        this.clientId = Preconditions.checkNotNull(clientId);
        this.authorizationServerEncodedUrl = Preconditions.checkNotNull(authorizationServerEncodedUrl);
        this.requestInitializer = requestInitializer;
        this.credentialStore = credentialStore;
        this.scopes = scopes;
        this.clock = Preconditions.checkNotNull(clock);
    }

    public AuthorizationCodeRequestUrl newAuthorizationUrl() {
        return new AuthorizationCodeRequestUrl(this.authorizationServerEncodedUrl, this.clientId).setScopes(this.scopes);
    }

    public AuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        return new AuthorizationCodeTokenRequest(this.transport, this.jsonFactory, new GenericUrl(this.tokenServerEncodedUrl), authorizationCode).setClientAuthentication(this.clientAuthentication).setRequestInitializer(this.requestInitializer).setScopes(this.scopes);
    }

    public Credential createAndStoreCredential(TokenResponse response, String userId) throws IOException {
        Credential credential = this.newCredential(userId).setFromTokenResponse(response);
        if (this.credentialStore != null) {
            this.credentialStore.store(userId, credential);
        }
        return credential;
    }

    public Credential loadCredential(String userId) throws IOException {
        if (this.credentialStore == null) {
            return null;
        }
        Credential credential = this.newCredential(userId);
        if (!this.credentialStore.load(userId, credential)) {
            return null;
        }
        return credential;
    }

    private Credential newCredential(String userId) {
        Credential.Builder builder = new Credential.Builder(this.method).setTransport(this.transport).setJsonFactory(this.jsonFactory).setTokenServerEncodedUrl(this.tokenServerEncodedUrl).setClientAuthentication(this.clientAuthentication).setRequestInitializer(this.requestInitializer).setClock(this.clock);
        if (this.credentialStore != null) {
            builder.addRefreshListener(new CredentialStoreRefreshListener(userId, this.credentialStore));
        }
        return builder.build();
    }

    public final Credential.AccessMethod getMethod() {
        return this.method;
    }

    public final HttpTransport getTransport() {
        return this.transport;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getTokenServerEncodedUrl() {
        return this.tokenServerEncodedUrl;
    }

    public final HttpExecuteInterceptor getClientAuthentication() {
        return this.clientAuthentication;
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getAuthorizationServerEncodedUrl() {
        return this.authorizationServerEncodedUrl;
    }

    public final CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    public final HttpRequestInitializer getRequestInitializer() {
        return this.requestInitializer;
    }

    public final String getScopes() {
        return this.scopes;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public static class Builder {
        private Credential.AccessMethod method;
        private HttpTransport transport;
        private JsonFactory jsonFactory;
        private GenericUrl tokenServerUrl;
        private HttpExecuteInterceptor clientAuthentication;
        private String clientId;
        private String authorizationServerEncodedUrl;
        private CredentialStore credentialStore;
        private HttpRequestInitializer requestInitializer;
        private String scopes;
        private Clock clock = Clock.SYSTEM;

        public Builder(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl) {
            this.setMethod(method);
            this.setTransport(transport);
            this.setJsonFactory(jsonFactory);
            this.setTokenServerUrl(tokenServerUrl);
            this.setClientAuthentication(clientAuthentication);
            this.setClientId(clientId);
            this.setAuthorizationServerEncodedUrl(authorizationServerEncodedUrl);
        }

        public AuthorizationCodeFlow build() {
            return new AuthorizationCodeFlow(this.method, this.transport, this.jsonFactory, this.tokenServerUrl, this.clientAuthentication, this.clientId, this.authorizationServerEncodedUrl, this.credentialStore, this.requestInitializer, this.scopes, this.clock);
        }

        public final Credential.AccessMethod getMethod() {
            return this.method;
        }

        public Builder setMethod(Credential.AccessMethod method) {
            this.method = Preconditions.checkNotNull(method);
            return this;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public Builder setTransport(HttpTransport transport) {
            this.transport = Preconditions.checkNotNull(transport);
            return this;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
            return this;
        }

        public final GenericUrl getTokenServerUrl() {
            return this.tokenServerUrl;
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            this.tokenServerUrl = Preconditions.checkNotNull(tokenServerUrl);
            return this;
        }

        public final HttpExecuteInterceptor getClientAuthentication() {
            return this.clientAuthentication;
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public Builder setClientId(String clientId) {
            this.clientId = Preconditions.checkNotNull(clientId);
            return this;
        }

        public final String getAuthorizationServerEncodedUrl() {
            return this.authorizationServerEncodedUrl;
        }

        public Builder setAuthorizationServerEncodedUrl(String authorizationServerEncodedUrl) {
            this.authorizationServerEncodedUrl = Preconditions.checkNotNull(authorizationServerEncodedUrl);
            return this;
        }

        public final CredentialStore getCredentialStore() {
            return this.credentialStore;
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = Preconditions.checkNotNull(clock);
            return this;
        }

        public Builder setCredentialStore(CredentialStore credentialStore) {
            this.credentialStore = credentialStore;
            return this;
        }

        public final HttpRequestInitializer getRequestInitializer() {
            return this.requestInitializer;
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            this.requestInitializer = requestInitializer;
            return this;
        }

        public Builder setScopes(Iterable<String> scopes) {
            this.scopes = scopes == null ? null : Joiner.on(' ').join(scopes);
            return this;
        }

        public Builder setScopes(String ... scopes) {
            return this.setScopes(scopes == null ? null : Arrays.asList(scopes));
        }

        public final String getScopes() {
            return this.scopes;
        }
    }
}

