/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.config.Api;
import com.google.api.server.spi.config.ApiMethod;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.User;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class WebApisUserService {
    private static final Logger logger = Logger.getLogger(WebApisUserService.class.getName());
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String[] ALLOWED_AUTH_SCHEMES = new String[]{"OAuth", "Bearer"};
    protected static final String[] OAUTH2_TOKEN_PREFIXES = new String[]{"ya29.", "1/"};
    protected static final String[] BEARER_TOKEN_PARAMETER_NAMES = new String[]{"access_token", "bearer_token"};
    private final GoogleIdTokenVerifier verifier;

    public WebApisUserService(Set<String> allowedClientIds) {
        GoogleIdTokenVerifier.Builder builder = new GoogleIdTokenVerifier.Builder(this.getTransport(), new JacksonFactory());
        if (allowedClientIds != null && allowedClientIds.size() > 0) {
            builder.setClientIds(allowedClientIds);
        }
        this.verifier = builder.build();
    }

    private HttpTransport getTransport() {
        if (SystemProperty.environment.value() == SystemProperty.Environment.Value.Production) {
            return new UrlFetchTransport();
        }
        return new NetHttpTransport();
    }

    public String matchAuthScheme(HttpServletRequest request) {
        return this.matchAuthScheme(request.getHeader(HEADER_AUTHORIZATION));
    }

    protected String matchAuthScheme(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        for (String authScheme : ALLOWED_AUTH_SCHEMES) {
            if (!authHeader.startsWith(authScheme)) continue;
            return authScheme;
        }
        return null;
    }

    public User getCurrentUser(HttpServletRequest request, Method method) {
        return this.getCurrentUser(this.getAuthToken(request), this.getAllowedScopes(method), this.getAllowedAudiences(method), this.getAllowedClientIds(method), SystemProperty.environment.value());
    }

    User getCurrentUser(String token, String[] allowedScopes, String[] allowedAudiences, String[] allowedClientIds) {
        return this.getCurrentUser(token, allowedScopes, allowedAudiences, allowedClientIds, SystemProperty.Environment.Value.Production);
    }

    User getCurrentUser(String token, String[] allowedScopes, String[] allowedAudiences, String[] allowedClientIds, SystemProperty.Environment.Value env) {
        logger.log(Level.FINE, "token={0}", token);
        logger.log(Level.FINE, "allowedScopes={0}", allowedScopes);
        logger.log(Level.FINE, "allowedAudiences={0}", allowedAudiences);
        logger.log(Level.FINE, "allowedClientIds={0}", allowedClientIds);
        if (token == null || token.trim().isEmpty()) {
            return null;
        }
        if (this.isIdToken(token)) {
            String idTokenEmail = this.getIdTokenEmail(token, allowedAudiences, allowedClientIds, env);
            logger.log(Level.INFO, "idToken email={0}", idTokenEmail);
            return idTokenEmail == null ? null : new User(idTokenEmail, "");
        }
        for (String allowedScope : allowedScopes) {
            try {
                User user = this.getOAuth2User(allowedScope);
                logger.log(Level.INFO, "getCurrentUser: OAuth2Token user={0}", user);
                return user;
            }
            catch (OAuthRequestException e) {
                logger.log(Level.WARNING, "OAuthRequestException: {0}", e.getMessage());
            }
        }
        logger.info("getCurrentUser: OAuth2Token user=null");
        return null;
    }

    String getAuthToken(HttpServletRequest request) {
        String token = this.getAuthTokenFromHeader(request.getHeader(HEADER_AUTHORIZATION));
        if (token == null) {
            token = this.getAuthTokenFromQueryParameters(request);
        }
        return token;
    }

    private String getAuthTokenFromQueryParameters(HttpServletRequest request) {
        for (String parameterName : BEARER_TOKEN_PARAMETER_NAMES) {
            String token = request.getParameter(parameterName);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    private String getAuthTokenFromHeader(String authHeader) {
        String authScheme = this.matchAuthScheme(authHeader);
        if (authScheme == null) {
            return null;
        }
        return authHeader.substring(authScheme.length() + 1);
    }

    boolean isIdToken(String token) {
        for (String prefix : OAUTH2_TOKEN_PREFIXES) {
            if (!token.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    String[] getAllowedScopes(Method method) {
        ApiMethod apiMethod = method.getAnnotation(ApiMethod.class);
        if (apiMethod == null) {
            return this.getClassDefaultAllowedScopes(method);
        }
        String[] scopes = apiMethod.scopes();
        return scopes.length > 0 ? scopes : this.getClassDefaultAllowedScopes(method);
    }

    private String[] getClassDefaultAllowedScopes(Method method) {
        Api api = method.getDeclaringClass().getAnnotation(Api.class);
        return api == null ? new String[]{} : api.scopes();
    }

    String[] getAllowedAudiences(Method method) {
        ApiMethod apiMethod = method.getAnnotation(ApiMethod.class);
        if (apiMethod == null) {
            return this.getClassDefaultAllowedAudiences(method);
        }
        String[] audiences = apiMethod.audiences();
        return audiences.length > 0 ? audiences : this.getClassDefaultAllowedAudiences(method);
    }

    private String[] getClassDefaultAllowedAudiences(Method method) {
        Api api = method.getDeclaringClass().getAnnotation(Api.class);
        return api == null ? new String[]{} : api.audiences();
    }

    String[] getAllowedClientIds(Method method) {
        ApiMethod apiMethod = method.getAnnotation(ApiMethod.class);
        if (apiMethod == null) {
            return this.getClassDefaultAllowedClientIds(method);
        }
        String[] clientIds = apiMethod.clientIds();
        return clientIds.length > 0 ? clientIds : this.getClassDefaultAllowedClientIds(method);
    }

    private String[] getClassDefaultAllowedClientIds(Method method) {
        Api api = method.getDeclaringClass().getAnnotation(Api.class);
        return api == null ? new String[]{} : api.clientIds();
    }

    GoogleIdToken verifyTokenInternal(String token) {
        try {
            return this.verifier.verify(token);
        }
        catch (GeneralSecurityException e) {
            logger.warning("getCurrentUser: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            logger.warning("getCurrentUser: " + e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.warning("getCurrentUser: " + e.getMessage());
            return null;
        }
    }

    private String getIdTokenEmail(String token, String[] allowedAudiences, String[] allowedClientIds, SystemProperty.Environment.Value env) {
        GoogleIdToken idToken = this.verifyTokenInternal(token);
        if (idToken == null) {
            logger.warning("getCurrentUser: idToken=null");
            return null;
        }
        if (!this.isAudienceAllowed(allowedAudiences, idToken)) {
            return null;
        }
        if (!this.isClientIdAllowed(allowedClientIds, idToken, env)) {
            return null;
        }
        return this.extractUser(idToken);
    }

    private boolean isAudienceAllowed(String[] allowedAudiences, GoogleIdToken idToken) {
        String audience = this.extractAudience(idToken);
        if (this.isEmptyOrWhitespace(audience)) {
            logger.warning("Token contained no audience: " + idToken.getPayload());
            return false;
        }
        if (allowedAudiences != null && allowedAudiences.length != 0) {
            for (String allowedAudience : allowedAudiences) {
                if (!audience.equals(allowedAudience)) continue;
                return true;
            }
        }
        if (audience.equals(this.extractClientId(idToken))) {
            return true;
        }
        logger.warning("Audience in token was not allowed: " + audience);
        return false;
    }

    private String extractAudience(GoogleIdToken idToken) {
        return (String)idToken.getPayload().get("aud");
    }

    private String extractClientId(GoogleIdToken idToken) {
        return (String)idToken.getPayload().get("cid");
    }

    private String extractUser(GoogleIdToken idToken) {
        return (String)idToken.getPayload().get("email");
    }

    private boolean isClientIdAllowed(String[] allowedClientIds, GoogleIdToken idToken, SystemProperty.Environment.Value env) {
        if (allowedClientIds == null || allowedClientIds.length == 0) {
            if (env == SystemProperty.Environment.Value.Development) {
                logger.warning("No Client ID was whitelisted. Allowing any Client ID for Development.");
                return true;
            }
            logger.warning("No Client ID was whitelisted. Not allowed in Production.");
            return false;
        }
        String clientId = this.extractClientId(idToken);
        for (String allowedClientId : allowedClientIds) {
            if (this.isEmptyOrWhitespace(allowedClientId) || !allowedClientId.equals(clientId)) continue;
            return true;
        }
        logger.warning("Client ID " + clientId + " is not whitelisted.");
        return false;
    }

    private boolean isEmptyOrWhitespace(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().isEmpty();
    }

    User getOAuth2User(String scope) throws OAuthRequestException {
        return OAuthServiceFactory.getOAuthService().getCurrentUser(scope);
    }
}

