/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class IoUtil {
    static final int BUFFER_SIZE = 1024;

    public static String readResourceFile(Class<?> c, String fileName) throws IOException {
        URL url = c.getResource(fileName);
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = in.readLine();
        while (line != null) {
            sb.append(line);
            line = in.readLine();
        }
        return sb.toString();
    }

    public static void copy(InputStream in, File dest) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[1024];
        int len = in.read(buf);
        while (len > 0) {
            ((OutputStream)out).write(buf, 0, len);
            len = in.read(buf);
        }
        in.close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[(int)file.length()];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            randomAccessFile.readFully(buffer);
            String string = new String(buffer, "UTF-8");
            return string;
        }
        finally {
            randomAccessFile.close();
        }
    }

    public static List<String> readFiles(File directory, FileFilter filter) throws FileNotFoundException, IOException {
        ArrayList<String> contents = new ArrayList<String>();
        for (File file : directory.listFiles(filter)) {
            contents.add(IoUtil.readFile(file));
        }
        return contents;
    }

    public static String readStream(InputStream is) throws IOException {
        return IoUtil.readStream(is, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readStream(InputStream is, int bufferSize) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[bufferSize];
            int n = is.read(buffer);
            while (n > 0) {
                os.write(buffer, 0, n);
                n = is.read(buffer);
            }
            String string = os.toString("UTF-8");
            return string;
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static void writeFile(String filePath, String fileContent) throws IOException {
        FileWriter w = new FileWriter(filePath);
        w.write(fileContent);
        ((Writer)w).flush();
        ((Writer)w).close();
    }
}

