/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Map;
import twitter4j.AccountSettings;
import twitter4j.AccountTotals;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.Friendship;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.PagableResponseList;
import twitter4j.Place;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.RelatedResults;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.SimilarPlaces;
import twitter4j.Status;
import twitter4j.Trends;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterException;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserMentionEntity;
import twitter4j.api.HelpResources;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.AccountSettingsJSONImpl;
import twitter4j.internal.json.AccountTotalsJSONImpl;
import twitter4j.internal.json.CategoryJSONImpl;
import twitter4j.internal.json.DirectMessageJSONImpl;
import twitter4j.internal.json.FriendshipJSONImpl;
import twitter4j.internal.json.HashtagEntityJSONImpl;
import twitter4j.internal.json.IDsJSONImpl;
import twitter4j.internal.json.LanguageJSONImpl;
import twitter4j.internal.json.LocationJSONImpl;
import twitter4j.internal.json.PlaceJSONImpl;
import twitter4j.internal.json.QueryResultJSONImpl;
import twitter4j.internal.json.RateLimitStatusJSONImpl;
import twitter4j.internal.json.RelatedResultsJSONImpl;
import twitter4j.internal.json.RelationshipJSONImpl;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.SavedSearchJSONImpl;
import twitter4j.internal.json.SimilarPlacesImpl;
import twitter4j.internal.json.StatusJSONImpl;
import twitter4j.internal.json.TrendsJSONImpl;
import twitter4j.internal.json.TwitterAPIConfigurationJSONImpl;
import twitter4j.internal.json.URLEntityJSONImpl;
import twitter4j.internal.json.UserJSONImpl;
import twitter4j.internal.json.UserListJSONImpl;
import twitter4j.internal.json.UserMentionEntityJSONImpl;
import twitter4j.internal.json.z_T4JInternalFactory;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.z_T4JInternalStringUtil;

public class z_T4JInternalJSONImplFactory
implements z_T4JInternalFactory {
    private static final long serialVersionUID = 5217622295050444866L;
    private Configuration conf;

    public z_T4JInternalJSONImplFactory(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Status createStatus(JSONObject json) throws TwitterException {
        return new StatusJSONImpl(json);
    }

    @Override
    public User createUser(JSONObject json) throws TwitterException {
        return new UserJSONImpl(json);
    }

    @Override
    public UserList createAUserList(JSONObject json) throws TwitterException {
        return new UserListJSONImpl(json);
    }

    @Override
    public DirectMessage createDirectMessage(JSONObject json) throws TwitterException {
        return new DirectMessageJSONImpl(json);
    }

    @Override
    public Map<String, RateLimitStatus> createRateLimitStatuses(HttpResponse res) throws TwitterException {
        return RateLimitStatusJSONImpl.createRateLimitStatuses(res, this.conf);
    }

    @Override
    public Status createStatus(HttpResponse res) throws TwitterException {
        return new StatusJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<Status> createStatusList(HttpResponse res) throws TwitterException {
        return StatusJSONImpl.createStatusList(res, this.conf);
    }

    static GeoLocation createGeoLocation(JSONObject json) throws TwitterException {
        try {
            if (!json.isNull("geo")) {
                String coordinates = json.getJSONObject("geo").getString("coordinates");
                coordinates = coordinates.substring(1, coordinates.length() - 1);
                String[] point = z_T4JInternalStringUtil.split(coordinates, ",");
                return new GeoLocation(Double.parseDouble(point[0]), Double.parseDouble(point[1]));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        return null;
    }

    static GeoLocation[][] coordinatesAsGeoLocationArray(JSONArray coordinates) throws TwitterException {
        try {
            GeoLocation[][] boundingBox = new GeoLocation[coordinates.length()][];
            for (int i = 0; i < coordinates.length(); ++i) {
                JSONArray array = coordinates.getJSONArray(i);
                boundingBox[i] = new GeoLocation[array.length()];
                for (int j = 0; j < array.length(); ++j) {
                    JSONArray coordinate = array.getJSONArray(j);
                    boundingBox[i][j] = new GeoLocation(coordinate.getDouble(1), coordinate.getDouble(0));
                }
            }
            return boundingBox;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public static RateLimitStatus createRateLimitStatusFromResponseHeader(HttpResponse res) {
        return RateLimitStatusJSONImpl.createFromResponseHeader(res);
    }

    @Override
    public Trends createTrends(HttpResponse res) throws TwitterException {
        return new TrendsJSONImpl(res, this.conf);
    }

    @Override
    public User createUser(HttpResponse res) throws TwitterException {
        return new UserJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<User> createUserList(HttpResponse res) throws TwitterException {
        return UserJSONImpl.createUserList(res, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray(HttpResponse res) throws TwitterException {
        return UserJSONImpl.createUserList(res.asJSONArray(), res, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray_Users(HttpResponse res) throws TwitterException {
        try {
            return UserJSONImpl.createUserList(res.asJSONObject().getJSONArray("users"), res, this.conf);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public QueryResult createQueryResult(HttpResponse res, Query query) throws TwitterException {
        try {
            return new QueryResultJSONImpl(res, this.conf);
        }
        catch (TwitterException te) {
            if (404 == te.getStatusCode()) {
                return new QueryResultJSONImpl(query);
            }
            throw te;
        }
    }

    @Override
    public IDs createIDs(HttpResponse res) throws TwitterException {
        return new IDsJSONImpl(res, this.conf);
    }

    @Override
    public PagableResponseList<User> createPagableUserList(HttpResponse res) throws TwitterException {
        return UserJSONImpl.createPagableUserList(res, this.conf);
    }

    @Override
    public UserList createAUserList(HttpResponse res) throws TwitterException {
        return new UserListJSONImpl(res, this.conf);
    }

    @Override
    public PagableResponseList<UserList> createPagableUserListList(HttpResponse res) throws TwitterException {
        return UserListJSONImpl.createPagableUserListList(res, this.conf);
    }

    @Override
    public ResponseList<UserList> createUserListList(HttpResponse res) throws TwitterException {
        return UserListJSONImpl.createUserListList(res, this.conf);
    }

    @Override
    public ResponseList<Category> createCategoryList(HttpResponse res) throws TwitterException {
        return CategoryJSONImpl.createCategoriesList(res, this.conf);
    }

    @Override
    public DirectMessage createDirectMessage(HttpResponse res) throws TwitterException {
        return new DirectMessageJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<DirectMessage> createDirectMessageList(HttpResponse res) throws TwitterException {
        return DirectMessageJSONImpl.createDirectMessageList(res, this.conf);
    }

    @Override
    public Relationship createRelationship(HttpResponse res) throws TwitterException {
        return new RelationshipJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<Friendship> createFriendshipList(HttpResponse res) throws TwitterException {
        return FriendshipJSONImpl.createFriendshipList(res, this.conf);
    }

    @Override
    public AccountTotals createAccountTotals(HttpResponse res) throws TwitterException {
        return new AccountTotalsJSONImpl(res, this.conf);
    }

    @Override
    public AccountSettings createAccountSettings(HttpResponse res) throws TwitterException {
        return new AccountSettingsJSONImpl(res, this.conf);
    }

    @Override
    public SavedSearch createSavedSearch(HttpResponse res) throws TwitterException {
        return new SavedSearchJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<SavedSearch> createSavedSearchList(HttpResponse res) throws TwitterException {
        return SavedSearchJSONImpl.createSavedSearchList(res, this.conf);
    }

    @Override
    public ResponseList<Location> createLocationList(HttpResponse res) throws TwitterException {
        return LocationJSONImpl.createLocationList(res, this.conf);
    }

    @Override
    public Place createPlace(HttpResponse res) throws TwitterException {
        return new PlaceJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<Place> createPlaceList(HttpResponse res) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(res, this.conf);
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public SimilarPlaces createSimilarPlaces(HttpResponse res) throws TwitterException {
        return SimilarPlacesImpl.createSimilarPlaces(res, this.conf);
    }

    @Override
    public RelatedResults createRelatedResults(HttpResponse res) throws TwitterException {
        return new RelatedResultsJSONImpl(res, this.conf);
    }

    @Override
    public TwitterAPIConfiguration createTwitterAPIConfiguration(HttpResponse res) throws TwitterException {
        return new TwitterAPIConfigurationJSONImpl(res, this.conf);
    }

    @Override
    public ResponseList<HelpResources.Language> createLanguageList(HttpResponse res) throws TwitterException {
        return LanguageJSONImpl.createLanguageList(res, this.conf);
    }

    @Override
    public <T> ResponseList<T> createEmptyResponseList() {
        return new ResponseListImpl(0, null);
    }

    public static HashtagEntity createHashtagEntity(int start, int end, String text) {
        return new HashtagEntityJSONImpl(start, end, text);
    }

    public static UserMentionEntity createUserMentionEntity(int start, int end, String name, String screenName, long id) {
        return new UserMentionEntityJSONImpl(start, end, name, screenName, id);
    }

    public static URLEntity createUrlEntity(int start, int end, String url, String expandedURL, String displayURL) {
        return new URLEntityJSONImpl(start, end, url, expandedURL, displayURL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof z_T4JInternalJSONImplFactory)) {
            return false;
        }
        z_T4JInternalJSONImplFactory that = (z_T4JInternalJSONImplFactory)o;
        return !(this.conf != null ? !this.conf.equals(that.conf) : that.conf != null);
    }

    public int hashCode() {
        return this.conf != null ? this.conf.hashCode() : 0;
    }

    public String toString() {
        return "JSONImplFactory{conf=" + this.conf + '}';
    }
}

