/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.TwitterResponseImpl;
import twitter4j.internal.json.z_T4JInternalParseUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class RelationshipJSONImpl
extends TwitterResponseImpl
implements Relationship,
Serializable {
    private static final long serialVersionUID = 7725021608907856360L;
    private final long targetUserId;
    private final String targetUserScreenName;
    private final boolean sourceBlockingTarget;
    private final boolean sourceNotificationsEnabled;
    private final boolean sourceFollowingTarget;
    private final boolean sourceFollowedByTarget;
    private final long sourceUserId;
    private final String sourceUserScreenName;

    RelationshipJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        this(res, res.asJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, res.asJSONObject());
        }
    }

    RelationshipJSONImpl(JSONObject json) throws TwitterException {
        this(null, json);
    }

    RelationshipJSONImpl(HttpResponse res, JSONObject json) throws TwitterException {
        super(res);
        try {
            JSONObject relationship = json.getJSONObject("relationship");
            JSONObject sourceJson = relationship.getJSONObject("source");
            JSONObject targetJson = relationship.getJSONObject("target");
            this.sourceUserId = z_T4JInternalParseUtil.getLong("id", sourceJson);
            this.targetUserId = z_T4JInternalParseUtil.getLong("id", targetJson);
            this.sourceUserScreenName = z_T4JInternalParseUtil.getUnescapedString("screen_name", sourceJson);
            this.targetUserScreenName = z_T4JInternalParseUtil.getUnescapedString("screen_name", targetJson);
            this.sourceBlockingTarget = z_T4JInternalParseUtil.getBoolean("blocking", sourceJson);
            this.sourceFollowingTarget = z_T4JInternalParseUtil.getBoolean("following", sourceJson);
            this.sourceFollowedByTarget = z_T4JInternalParseUtil.getBoolean("followed_by", sourceJson);
            this.sourceNotificationsEnabled = z_T4JInternalParseUtil.getBoolean("notifications_enabled", sourceJson);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    static ResponseList<Relationship> createRelationshipList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<Relationship> relationships = new ResponseListImpl<Relationship>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                RelationshipJSONImpl relationship = new RelationshipJSONImpl(json);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(relationship, json);
                }
                relationships.add(relationship);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(relationships, list);
            }
            return relationships;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    @Override
    public long getSourceUserId() {
        return this.sourceUserId;
    }

    @Override
    public long getTargetUserId() {
        return this.targetUserId;
    }

    @Override
    public boolean isSourceBlockingTarget() {
        return this.sourceBlockingTarget;
    }

    @Override
    public String getSourceUserScreenName() {
        return this.sourceUserScreenName;
    }

    @Override
    public String getTargetUserScreenName() {
        return this.targetUserScreenName;
    }

    @Override
    public boolean isSourceFollowingTarget() {
        return this.sourceFollowingTarget;
    }

    @Override
    public boolean isTargetFollowingSource() {
        return this.sourceFollowedByTarget;
    }

    @Override
    public boolean isSourceFollowedByTarget() {
        return this.sourceFollowedByTarget;
    }

    @Override
    public boolean isTargetFollowedBySource() {
        return this.sourceFollowingTarget;
    }

    @Override
    public boolean isSourceNotificationsEnabled() {
        return this.sourceNotificationsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship that = (Relationship)o;
        if (this.sourceUserId != that.getSourceUserId()) {
            return false;
        }
        if (this.targetUserId != that.getTargetUserId()) {
            return false;
        }
        if (!this.sourceUserScreenName.equals(that.getSourceUserScreenName())) {
            return false;
        }
        return this.targetUserScreenName.equals(that.getTargetUserScreenName());
    }

    public int hashCode() {
        int result = (int)(this.targetUserId ^ this.targetUserId >>> 32);
        result = 31 * result + (this.targetUserScreenName != null ? this.targetUserScreenName.hashCode() : 0);
        result = 31 * result + (this.sourceBlockingTarget ? 1 : 0);
        result = 31 * result + (this.sourceNotificationsEnabled ? 1 : 0);
        result = 31 * result + (this.sourceFollowingTarget ? 1 : 0);
        result = 31 * result + (this.sourceFollowedByTarget ? 1 : 0);
        result = 31 * result + (int)(this.sourceUserId ^ this.sourceUserId >>> 32);
        result = 31 * result + (this.sourceUserScreenName != null ? this.sourceUserScreenName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RelationshipJSONImpl{sourceUserId=" + this.sourceUserId + ", targetUserId=" + this.targetUserId + ", sourceUserScreenName='" + this.sourceUserScreenName + '\'' + ", targetUserScreenName='" + this.targetUserScreenName + '\'' + ", sourceFollowingTarget=" + this.sourceFollowingTarget + ", sourceFollowedByTarget=" + this.sourceFollowedByTarget + ", sourceNotificationsEnabled=" + this.sourceNotificationsEnabled + '}';
    }
}

