/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import java.util.Date;
import twitter4j.DirectMessage;
import twitter4j.ResponseList;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.TwitterResponseImpl;
import twitter4j.internal.json.UserJSONImpl;
import twitter4j.internal.json.z_T4JInternalParseUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

final class DirectMessageJSONImpl
extends TwitterResponseImpl
implements DirectMessage,
Serializable {
    private static final long serialVersionUID = -7104233663827757577L;
    private long id;
    private String text;
    private long senderId;
    private long recipientId;
    private Date createdAt;
    private String senderScreenName;
    private String recipientScreenName;
    private User sender;
    private User recipient;

    DirectMessageJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    DirectMessageJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = z_T4JInternalParseUtil.getLong("id", json);
        this.text = z_T4JInternalParseUtil.getUnescapedString("text", json);
        this.senderId = z_T4JInternalParseUtil.getLong("sender_id", json);
        this.recipientId = z_T4JInternalParseUtil.getLong("recipient_id", json);
        this.createdAt = z_T4JInternalParseUtil.getDate("created_at", json);
        this.senderScreenName = z_T4JInternalParseUtil.getUnescapedString("sender_screen_name", json);
        this.recipientScreenName = z_T4JInternalParseUtil.getUnescapedString("recipient_screen_name", json);
        try {
            this.sender = new UserJSONImpl(json.getJSONObject("sender"));
            this.recipient = new UserJSONImpl(json.getJSONObject("recipient"));
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public long getSenderId() {
        return this.senderId;
    }

    @Override
    public long getRecipientId() {
        return this.recipientId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getSenderScreenName() {
        return this.senderScreenName;
    }

    @Override
    public String getRecipientScreenName() {
        return this.recipientScreenName;
    }

    @Override
    public User getSender() {
        return this.sender;
    }

    @Override
    public User getRecipient() {
        return this.recipient;
    }

    static ResponseList<DirectMessage> createDirectMessageList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<DirectMessage> directMessages = new ResponseListImpl<DirectMessage>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                DirectMessageJSONImpl directMessage = new DirectMessageJSONImpl(json);
                directMessages.add(directMessage);
                if (!conf.isJSONStoreEnabled()) continue;
                DataObjectFactoryUtil.registerJSONObject(directMessage, json);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(directMessages, list);
            }
            return directMessages;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof DirectMessage && ((DirectMessage)obj).getId() == this.id;
    }

    public String toString() {
        return "DirectMessageJSONImpl{id=" + this.id + ", text='" + this.text + '\'' + ", sender_id=" + this.senderId + ", recipient_id=" + this.recipientId + ", created_at=" + this.createdAt + ", sender_screen_name='" + this.senderScreenName + '\'' + ", recipient_screen_name='" + this.recipientScreenName + '\'' + ", sender=" + this.sender + ", recipient=" + this.recipient + '}';
    }
}

