/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.google.common.base;

import com.google.appengine.labs.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.labs.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.labs.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.labs.repackaged.com.google.common.base.CharMatcher;
import java.util.BitSet;

@GwtCompatible(emulated=true)
final class SmallCharMatcher
extends CharMatcher.FastMatcher {
    static final int MAX_SIZE = 63;
    static final int MAX_TABLE_SIZE = 128;
    private final boolean reprobe;
    private final char[] table;
    private final boolean containsZero;
    final long filter;

    private SmallCharMatcher(char[] table, long filter, boolean containsZero, boolean reprobe, String description) {
        super(description);
        this.table = table;
        this.filter = filter;
        this.containsZero = containsZero;
        this.reprobe = reprobe;
    }

    private boolean checkFilter(int c) {
        return 1L == (1L & this.filter >> c);
    }

    @VisibleForTesting
    static char[] buildTable(int modulus, char[] charArray, boolean reprobe) {
        char[] table = new char[modulus];
        for (char c : charArray) {
            int index = c % modulus;
            if (index < 0) {
                index += modulus;
            }
            if (table[index] != '\u0000' && !reprobe) {
                return null;
            }
            if (reprobe) {
                while (table[index] != '\u0000') {
                    index = (index + 1) % modulus;
                }
            }
            table[index] = c;
        }
        return table;
    }

    @GwtIncompatible(value="java.util.BitSet")
    static CharMatcher from(BitSet chars, String description) {
        char[] charArray = new char[chars.cardinality()];
        int i = 0;
        int c = chars.nextSetBit(0);
        while (c != -1) {
            charArray[i++] = (char)c;
            c = chars.nextSetBit(c + 1);
        }
        return SmallCharMatcher.from(charArray, description);
    }

    static CharMatcher from(char[] chars, String description) {
        int size = chars.length;
        boolean containsZero = chars[0] == '\u0000';
        boolean reprobe = false;
        long filter = 0L;
        for (char c : chars) {
            filter |= 1L << c;
        }
        char[] table = null;
        for (int i = size; table == null && i < 128; ++i) {
            table = SmallCharMatcher.buildTable(i, chars, false);
        }
        if (table == null) {
            table = SmallCharMatcher.buildTable(128, chars, true);
            reprobe = true;
        }
        return new SmallCharMatcher(table, filter, containsZero, reprobe, description);
    }

    @Override
    public boolean matches(char c) {
        if (c == '\u0000') {
            return this.containsZero;
        }
        if (!this.checkFilter(c)) {
            return false;
        }
        int index = c % this.table.length;
        if (index < 0) {
            index += this.table.length;
        }
        while (true) {
            if (this.table[index] == '\u0000') {
                return false;
            }
            if (this.table[index] == c) {
                return true;
            }
            if (!this.reprobe) break;
            index = (index + 1) % this.table.length;
        }
        return false;
    }

    @Override
    @GwtIncompatible(value="java.util.BitSet")
    void setBits(BitSet bitSet) {
        if (this.containsZero) {
            bitSet.set(0);
        }
        for (char c : this.table) {
            if (c == '\u0000') continue;
            bitSet.set(c);
        }
    }
}

