/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.ListDocumentsRequestChecker;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.Util;

public final class ListDocumentsRequest {
    private final String startDocId;
    private final Boolean includeStartDoc;
    private final Integer limit;
    private final Boolean keysOnly;

    private ListDocumentsRequest(Builder builder) {
        this.startDocId = builder.startDocId;
        this.includeStartDoc = this.startDocId == null ? null : Util.defaultIfNull(builder.includeStartDoc, Boolean.TRUE);
        this.limit = Util.defaultIfNull(builder.limit, 100);
        this.keysOnly = builder.keysOnly;
        this.checkValid();
    }

    public static final Builder newBuilder() {
        return new Builder();
    }

    public static final Builder newBuilder(ListDocumentsRequest request) {
        return new Builder(request);
    }

    public String getStartDocId() {
        return this.startDocId;
    }

    public boolean isIncludeStartDoc() {
        return this.includeStartDoc;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean isKeysOnly() {
        return this.keysOnly;
    }

    private ListDocumentsRequest checkValid() {
        if (this.limit != null) {
            Preconditions.checkArgument(this.limit > 0, "Limit must be positive");
        }
        return this;
    }

    SearchServicePb.ListDocumentsParams.Builder copyToProtocolBuffer() {
        SearchServicePb.ListDocumentsParams.Builder builder = SearchServicePb.ListDocumentsParams.newBuilder();
        if (this.keysOnly != null) {
            builder.setKeysOnly(this.keysOnly);
        }
        if (this.startDocId != null) {
            builder.setStartDocId(this.startDocId);
        }
        if (this.includeStartDoc != null) {
            builder.setIncludeStartDoc(this.includeStartDoc);
        }
        if (this.limit != null) {
            builder.setLimit(this.limit);
        }
        return builder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeStartDoc == null ? 0 : this.includeStartDoc.hashCode());
        result = 31 * result + (this.keysOnly == null ? 0 : this.keysOnly.hashCode());
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + (this.startDocId == null ? 0 : this.startDocId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest)obj;
        return Util.equalObjects(this.includeStartDoc, other.includeStartDoc) && Util.equalObjects(this.keysOnly, other.keysOnly) && Util.equalObjects(this.limit, other.limit) && Util.equalObjects(this.startDocId, other.startDocId);
    }

    public String toString() {
        return "ListDocumentsRequest(includeStartDoc=" + this.includeStartDoc + ", startDocId=" + this.startDocId + ", limit=" + this.limit + ", keysOnly=" + this.keysOnly + ")";
    }

    public static final class Builder {
        private String startDocId;
        private Boolean includeStartDoc;
        private Integer limit;
        private Boolean keysOnly;

        private Builder() {
            this.includeStartDoc = true;
            this.keysOnly = false;
        }

        private Builder(ListDocumentsRequest request) {
            this.startDocId = request.getStartDocId();
            this.includeStartDoc = request.isIncludeStartDoc();
            this.limit = request.getLimit();
            this.keysOnly = request.isKeysOnly();
        }

        public Builder setStartDocId(String startDocId) {
            this.startDocId = ListDocumentsRequestChecker.checkStartDocId(startDocId);
            return this;
        }

        public Builder setIncludeStartDoc(boolean includeStartDoc) {
            this.includeStartDoc = includeStartDoc;
            return this;
        }

        public Builder setLimit(Integer limit) {
            this.limit = ListDocumentsRequestChecker.checkLimit(limit);
            return this;
        }

        public Builder setKeysOnly(boolean keysOnly) {
            this.keysOnly = keysOnly;
            return this;
        }

        public ListDocumentsRequest build() {
            return new ListDocumentsRequest(this);
        }
    }
}

