/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.search.AddDocumentsException;
import com.google.appengine.api.search.AddDocumentsResponse;
import com.google.appengine.api.search.Consistency;
import com.google.appengine.api.search.DeleteDocumentsException;
import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.DocumentChecker;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.FutureHelper;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexChecker;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.ListDocumentsException;
import com.google.appengine.api.search.ListDocumentsRequest;
import com.google.appengine.api.search.ListDocumentsResponse;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Preconditions;
import com.google.appengine.api.search.Schema;
import com.google.appengine.api.search.SearchApiHelper;
import com.google.appengine.api.search.SearchException;
import com.google.appengine.api.search.SearchRequest;
import com.google.appengine.api.search.SearchResponse;
import com.google.appengine.api.search.SearchResult;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.StatusCode;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

class IndexImpl
implements Index {
    private final SearchApiHelper apiHelper;
    private final String name;
    private final String namespace;
    private final Consistency consistency;
    private final Schema schema;

    IndexImpl(SearchApiHelper apiHelper, String namespace, IndexSpec indexSpec) {
        this(apiHelper, namespace, indexSpec, null);
    }

    IndexImpl(SearchApiHelper apiHelper, String namespace, IndexSpec indexSpec, Schema schema) {
        this.apiHelper = Preconditions.checkNotNull(apiHelper, "Internal error");
        this.consistency = Util.defaultIfNull(indexSpec.getConsistency(), Consistency.PER_DOCUMENT);
        this.name = IndexChecker.checkName(indexSpec.getName());
        this.namespace = namespace;
        NamespaceManager.validateNamespace(namespace);
        this.schema = schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Consistency getConsistency() {
        return this.consistency;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.consistency.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexImpl other = (IndexImpl)obj;
        return Util.equalObjects(this.name, other.name) && Util.equalObjects(this.namespace, other.namespace) && Util.equalObjects((Object)this.consistency, (Object)other.consistency) && Util.equalObjects(this.schema, other.schema);
    }

    public String toString() {
        return String.format("%s:%s(%s)%s", this.namespace, this.name, this.consistency.name(), this.schema == null ? "" : this.schema);
    }

    SearchServicePb.IndexSpec.Builder copyToProtocolBuffer() {
        SearchServicePb.IndexSpec.Builder builder = SearchServicePb.IndexSpec.newBuilder().setName(this.getName()).setNamespace(this.getNamespace());
        switch (this.getConsistency().getConsistency()) {
            case GLOBAL: {
                builder.setConsistency(SearchServicePb.IndexSpec.Consistency.GLOBAL);
                break;
            }
            case PER_DOCUMENT: {
                builder.setConsistency(SearchServicePb.IndexSpec.Consistency.PER_DOCUMENT);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unknown consistency type %s", this.getConsistency().getConsistency().name()));
            }
        }
        return builder;
    }

    @Override
    public Future<Void> deleteDocumentAsync(String documentId) {
        return this.deleteDocumentsAsync(Collections.singletonList(DocumentChecker.checkDocumentId(documentId)));
    }

    @Override
    public Future<Void> deleteDocumentsAsync(Iterable<String> documentIds) {
        Preconditions.checkArgument(documentIds != null, "Delete documents given null collection of document ids");
        SearchServicePb.DeleteDocumentParams.Builder builder = SearchServicePb.DeleteDocumentParams.newBuilder().setIndexSpec(this.copyToProtocolBuffer());
        int size = 0;
        for (String documentId : documentIds) {
            ++size;
            builder.addDocId(DocumentChecker.checkDocumentId(documentId));
        }
        if (size > 200) {
            throw new IllegalArgumentException(String.format("number of doc ids, %s, exceeds maximum %s", size, 200));
        }
        final int documentIdsSize = size;
        SearchServicePb.DeleteDocumentRequest request = SearchServicePb.DeleteDocumentRequest.newBuilder().setParams(builder).build();
        SearchServicePb.DeleteDocumentResponse.Builder responseBuilder = SearchServicePb.DeleteDocumentResponse.newBuilder();
        Future<SearchServicePb.DeleteDocumentResponse.Builder> future = this.apiHelper.makeAsyncCall("DeleteDocument", request, responseBuilder);
        return new FutureWrapper<SearchServicePb.DeleteDocumentResponse.Builder, Void>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new DeleteDocumentsException(result);
            }

            @Override
            protected Void wrap(SearchServicePb.DeleteDocumentResponse.Builder key) throws Exception {
                SearchServicePb.DeleteDocumentResponse response = key.build();
                ArrayList<OperationResult> results = new ArrayList<OperationResult>(response.getStatusCount());
                for (SearchServicePb.RequestStatus status : response.getStatusList()) {
                    results.add(new OperationResult(status));
                }
                if (documentIdsSize != response.getStatusList().size()) {
                    throw new DeleteDocumentsException(new OperationResult(StatusCode.INTERNAL_ERROR, String.format("Expected %d deleted documents, but got %d", documentIdsSize, response.getStatusList().size())), results);
                }
                for (OperationResult result : results) {
                    if (result.getCode() == StatusCode.OK) continue;
                    throw new DeleteDocumentsException(result, results);
                }
                return null;
            }
        };
    }

    @Override
    public Future<AddDocumentsResponse> addAsync(Document document) {
        return this.addAsync(Collections.singletonList(document));
    }

    @Override
    public Future<AddDocumentsResponse> addAsync(Iterable<Document> documents) {
        Preconditions.checkNotNull(documents, "document list cannot be null");
        if (!documents.iterator().hasNext()) {
            return new FutureHelper.FakeFuture<AddDocumentsResponse>(new AddDocumentsResponse(Collections.<OperationResult>emptyList(), Collections.<String>emptyList()));
        }
        SearchServicePb.IndexDocumentParams.Builder builder = SearchServicePb.IndexDocumentParams.newBuilder().setIndexSpec(this.copyToProtocolBuffer());
        int size = 0;
        for (Document document : documents) {
            ++size;
            builder.addDocument(Preconditions.checkNotNull(document, "document cannot be null").copyToProtocolBuffer());
        }
        if (size > 200) {
            throw new IllegalArgumentException(String.format("number of documents, %s, exceeds maximum %s", size, 200));
        }
        final int documentsSize = size;
        SearchServicePb.IndexDocumentRequest request = SearchServicePb.IndexDocumentRequest.newBuilder().setParams(builder).build();
        SearchServicePb.IndexDocumentResponse.Builder responseBuilder = SearchServicePb.IndexDocumentResponse.newBuilder();
        Future<SearchServicePb.IndexDocumentResponse.Builder> future = this.apiHelper.makeAsyncCall("IndexDocument", request, responseBuilder);
        return new FutureWrapper<SearchServicePb.IndexDocumentResponse.Builder, AddDocumentsResponse>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new AddDocumentsException(result);
            }

            @Override
            protected AddDocumentsResponse wrap(SearchServicePb.IndexDocumentResponse.Builder key) throws Exception {
                SearchServicePb.IndexDocumentResponse response = key.build();
                List<OperationResult> results = this.newOperationResultList(response);
                if (documentsSize != response.getStatusList().size()) {
                    throw new AddDocumentsException(new OperationResult(StatusCode.INTERNAL_ERROR, String.format("Expected %d indexed documents, but got %d", documentsSize, response.getStatusList().size())), results, response.getDocIdList());
                }
                for (OperationResult result : results) {
                    if (result.getCode() == StatusCode.OK) continue;
                    throw new AddDocumentsException(result, results, response.getDocIdList());
                }
                return new AddDocumentsResponse(results, response.getDocIdList());
            }

            private List<OperationResult> newOperationResultList(SearchServicePb.IndexDocumentResponse response) {
                ArrayList<OperationResult> results = new ArrayList<OperationResult>(response.getStatusCount());
                for (SearchServicePb.RequestStatus status : response.getStatusList()) {
                    results.add(new OperationResult(status));
                }
                return results;
            }
        };
    }

    private Future<SearchResponse> executeSearch(SearchServicePb.SearchParams.Builder params) {
        SearchServicePb.SearchResponse.Builder responseBuilder = SearchServicePb.SearchResponse.newBuilder();
        SearchServicePb.SearchRequest request = SearchServicePb.SearchRequest.newBuilder().setParams(params).build();
        Future<SearchServicePb.SearchResponse.Builder> future = this.apiHelper.makeAsyncCall("Search", request, responseBuilder);
        return new FutureWrapper<SearchServicePb.SearchResponse.Builder, SearchResponse>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new SearchException(result);
            }

            @Override
            protected SearchResponse wrap(SearchServicePb.SearchResponse.Builder key) throws Exception {
                SearchServicePb.SearchResponse response = key.build();
                SearchServicePb.RequestStatus status = response.getStatus();
                if (status.getCode() != SearchServicePb.SearchServiceError.ErrorCode.OK) {
                    throw new SearchException(new OperationResult(status));
                }
                ArrayList<SearchResult> results = new ArrayList<SearchResult>();
                for (SearchServicePb.SearchResult result : response.getResultList()) {
                    ArrayList<Field> expressions = new ArrayList<Field>();
                    for (DocumentPb.Field expression : result.getExpressionList()) {
                        expressions.add(Field.newBuilder(expression).build());
                    }
                    results.add(new SearchResult(Document.newBuilder(result.getDocument()).build(), result.getScoreList(), expressions, response.hasCursor() ? response.getCursor() : null));
                }
                SearchResponse searchResponse = new SearchResponse(new OperationResult(status), results, response.getMatchedCount(), response.getResultCount(), response.hasCursor() ? response.getCursor() : null);
                return searchResponse;
            }
        };
    }

    @Override
    public Future<SearchResponse> searchAsync(String query) {
        return this.searchAsync(SearchRequest.newBuilder().setQuery(Preconditions.checkNotNull(query, "query cannot be null")).build());
    }

    @Override
    public Future<SearchResponse> searchAsync(SearchRequest request) {
        Preconditions.checkNotNull(request, "search request cannot be null");
        return this.executeSearch(request.copyToProtocolBuffer().setIndexSpec(this.copyToProtocolBuffer()));
    }

    @Override
    public Future<ListDocumentsResponse> listDocumentsAsync(ListDocumentsRequest request) {
        Preconditions.checkNotNull(request, "list documents request cannot be null");
        SearchServicePb.ListDocumentsParams.Builder params = request.copyToProtocolBuffer().setIndexSpec(this.copyToProtocolBuffer());
        SearchServicePb.ListDocumentsResponse.Builder responseBuilder = SearchServicePb.ListDocumentsResponse.newBuilder();
        SearchServicePb.ListDocumentsRequest requestPb = SearchServicePb.ListDocumentsRequest.newBuilder().setParams(params).build();
        Future<SearchServicePb.ListDocumentsResponse.Builder> future = this.apiHelper.makeAsyncCall("ListDocuments", requestPb, responseBuilder);
        return new FutureWrapper<SearchServicePb.ListDocumentsResponse.Builder, ListDocumentsResponse>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new ListDocumentsException(result);
            }

            @Override
            protected ListDocumentsResponse wrap(SearchServicePb.ListDocumentsResponse.Builder key) throws Exception {
                SearchServicePb.ListDocumentsResponse response = key.build();
                SearchServicePb.RequestStatus status = response.getStatus();
                if (status.getCode() != SearchServicePb.SearchServiceError.ErrorCode.OK) {
                    throw new ListDocumentsException(new OperationResult(status));
                }
                ArrayList<Document> results = new ArrayList<Document>();
                for (DocumentPb.Document document : response.getDocumentList()) {
                    results.add(Document.newBuilder(document).build());
                }
                return new ListDocumentsResponse(results);
            }
        };
    }

    @Override
    public void deleteDocument(String documentId) {
        FutureHelper.quietGet(this.deleteDocumentAsync(documentId));
    }

    @Override
    public void deleteDocuments(Iterable<String> documentIds) {
        FutureHelper.quietGet(this.deleteDocumentsAsync(documentIds));
    }

    @Override
    public AddDocumentsResponse add(Document document) {
        return FutureHelper.quietGet(this.addAsync(document));
    }

    @Override
    public AddDocumentsResponse add(Iterable<Document> documents) {
        return FutureHelper.quietGet(this.addAsync(documents));
    }

    @Override
    public SearchResponse search(String query) {
        return FutureHelper.quietGet(this.searchAsync(query));
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        return FutureHelper.quietGet(this.searchAsync(request));
    }

    @Override
    public ListDocumentsResponse listDocuments(ListDocumentsRequest request) {
        return FutureHelper.quietGet(this.listDocumentsAsync(request));
    }
}

